/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.controller.impl;

import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerRequestListener;
import com.konylabs.middleware.controller.impl.AbstractDataControllerRequestImpl;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.session.impl.SessionImpl;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.cookie.Cookie;

public class DataControllerRequestImpl
extends AbstractDataControllerRequestImpl {
    private final Map<String, Object> attributeMap = new HashMap<String, Object>(0);
    private final List<File> files = new ArrayList<File>(0);
    private final String remoteAddress;
    private Map<String, String[]> paramMap;
    private Map<String, Object> headerMap;
    private Session session;
    private DataControllerRequestListener listener;
    private String queryString;

    public DataControllerRequestImpl(Map<String, Object> map) {
        this(map, null);
    }

    public DataControllerRequestImpl(Map<String, Object> map, Map<String, Object> headerMap) {
        this(map, headerMap, null);
    }

    public DataControllerRequestImpl(Map<String, Object> map, Map<String, Object> headerMap, String remoteAddress) {
        this(map, headerMap, remoteAddress, null, null);
    }

    public DataControllerRequestImpl(Map<String, Object> map, Map<String, Object> headerMap, String remoteAddress, DataControllerRequestListener listener, String queryString) {
        this(map, headerMap, remoteAddress, null, null, listener, queryString);
    }

    public DataControllerRequestImpl(Map<String, Object> map, Map<String, Object> headerMap, String remoteAddress, javax.servlet.http.Cookie[] cookies, Map<String, Cookie> apacheCookies, DataControllerRequestListener listener, String queryString) {
        this.updateOriginalRequest(map);
        this.headerMap = headerMap;
        this.remoteAddress = remoteAddress;
        if (apacheCookies != null && !apacheCookies.isEmpty()) {
            this.addCookies(apacheCookies);
        } else {
            this.extractCookiesAndConvertToApacheCookies(cookies);
        }
        this.listener = listener;
        this.queryString = queryString;
    }

    public void updateOriginalRequest(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        this.paramMap = new HashMap<String, String[]>(map.size());
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof String[]) {
                this.paramMap.put(key, (String[])value);
                continue;
            }
            if (value instanceof String) {
                this.addRequestParam_(key, (String)value);
                continue;
            }
            if (value instanceof File) {
                this.files.add((File)value);
                continue;
            }
            if (value instanceof Date) {
                this.addRequestParam_(key, MiddlewareUtils.getFormattedDateString((Date)value));
                continue;
            }
            if (value == null) continue;
            this.addRequestParam_(key, value.toString());
        }
    }

    public String getParameter(String name) {
        String[] paramValues = this.paramMap.get(name);
        return paramValues != null ? paramValues[0] : null;
    }

    public String[] getParameterValues(String name) {
        return this.paramMap.get(name);
    }

    public Iterator<String> getParameterNames() {
        return this.paramMap.keySet().iterator();
    }

    public File getUploadedFile(String name) {
        for (File file : this.files) {
            if (!name.equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    public String[] getUploadedFileNames() {
        String[] fileNames = new String[this.files.size()];
        int i = 0;
        for (File file : this.files) {
            fileNames[i++] = file.getName();
        }
        return fileNames;
    }

    public File[] getUploadedFiles() {
        return this.files.toArray(new File[this.files.size()]);
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public void setAttribute(String name, Object val) {
        this.attributeMap.put(name, val);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributeMap.keySet().iterator();
    }

    public Map<String, String[]> getSource() {
        return this.paramMap;
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean flag) {
        if (this.session == null) {
            this.session = this.listener != null ? new SessionImpl(this.listener.getSessionListener()) : new SessionImpl();
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean containsKeyInRequestContext(String key) {
        return this.attributeMap.containsKey(key);
    }

    public boolean containsKeyInRequest(String key) {
        return this.paramMap.containsKey(key);
    }

    public Object getOriginalRequest() {
        return null;
    }

    public String getHeader(String headerKey) {
        if (this.headerMap != null) {
            if (this.headerMap.get(headerKey) != null) {
                return this.headerMap.get(headerKey).toString();
            }
            if (this.headerMap.get(headerKey.toLowerCase()) != null) {
                return this.headerMap.get(headerKey.toLowerCase()).toString();
            }
        }
        return null;
    }

    public void addRequestParam_(String key, String value) {
        this.paramMap.put(key, new String[]{value});
    }

    public String getRemoteAddr() {
        return this.remoteAddress;
    }

    @Override
    public DataControllerRequest clone() {
        super.clone();
        DataControllerRequestImpl newRequest = new DataControllerRequestImpl(null, null, this.remoteAddress);
        if (this.paramMap != null) {
            if (newRequest.paramMap == null) {
                newRequest.paramMap = new HashMap<String, String[]>();
            }
            newRequest.paramMap.putAll(this.paramMap);
        }
        if (this.headerMap != null) {
            if (newRequest.headerMap == null) {
                newRequest.headerMap = new HashMap<String, Object>();
            }
            newRequest.headerMap.putAll(this.headerMap);
        }
        newRequest.attributeMap.putAll(this.attributeMap);
        newRequest.files.addAll(this.files);
        newRequest.cookies.putAll(this.cookies);
        newRequest.session = this.session;
        return newRequest;
    }

    public Map<String, Object> getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, Object>();
        }
        return this.headerMap;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }
}

