/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.controller.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kony.mapper.model.NodeElement;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.impl.AbstractDataControllerRequestImpl;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.session.impl.HttpSessionImpl;
import com.konylabs.middleware.session.impl.SessionImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DataControllerRequestRowImpl
extends AbstractDataControllerRequestImpl {
    private final Row row;
    private final Map<String, Object> attributesMap = new HashMap<String, Object>(0);
    private Map<String, Object> headerMap;
    private Session session;
    private HttpServletRequest request;

    public DataControllerRequestRowImpl(Row row, HttpServletRequest request) {
        this(row, DataControllerRequestRowImpl.getHeaders(request), request.getCookies());
        this.headerMap.putAll(this.consumeHeadersFromCustomProcessor(request));
        this.request = request;
    }

    public DataControllerRequestRowImpl(Row row, Map<String, Object> headerMap, Cookie[] cookies) {
        this.headerMap = headerMap;
        this.row = row;
        this.extractCookiesAndConvertToApacheCookies(cookies);
    }

    public void updateOriginalRequest(Map<String, Object> map) {
    }

    public String getParameter(String name) {
        JsonElement jsonElement;
        NodeElement rowElement = this.row.getValue(name);
        if (rowElement != null && (jsonElement = rowElement.getJsonElement()) != null) {
            return jsonElement.isJsonPrimitive() ? jsonElement.getAsString() : jsonElement.toString();
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributesMap.get(name);
    }

    public void setAttribute(String name, Object val) {
        this.attributesMap.put(name, val);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributesMap.keySet().iterator();
    }

    public Iterator<String> getParameterNames() {
        HashSet paramNames = new HashSet();
        JsonObject asJsonObject = this.row.getJsonElement().getAsJsonObject();
        if (asJsonObject != null) {
            Set entries = asJsonObject.entrySet();
            for (Map.Entry entry : entries) {
                paramNames.add(entry.getKey());
            }
        }
        return paramNames.iterator();
    }

    public String[] getUploadedFileNames() {
        return null;
    }

    public File getUploadedFile(String name) {
        return null;
    }

    public File[] getUploadedFiles() {
        return null;
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean flag) {
        HttpSession session = this.request.getSession(flag);
        return session == null ? new SessionImpl() : new HttpSessionImpl(session);
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean containsKeyInRequestContext(String key) {
        return this.attributesMap.containsKey(key);
    }

    public boolean containsKeyInRequest(String key) {
        return this.row.getJsonElement().getAsJsonObject().has(key);
    }

    public Map<String, String[]> getSource() {
        return null;
    }

    public Object getOriginalRequest() {
        return this.request;
    }

    public String getHeader(String headerKey) {
        if (this.headerMap != null) {
            if (this.headerMap.get(headerKey) != null) {
                return this.headerMap.get(headerKey).toString();
            }
            if (this.headerMap.get(headerKey.toLowerCase()) != null) {
                return this.headerMap.get(headerKey.toLowerCase()).toString();
            }
        }
        return null;
    }

    public Map<String, Object> getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, Object>();
        }
        return this.headerMap;
    }

    public void addRequestParam_(String key, String value) {
        this.row.getJsonElement().getAsJsonObject().addProperty(key, value);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    @Override
    public DataControllerRequest clone() {
        super.clone();
        JsonElement jsonElement = this.row.getJsonElement();
        Row clonedRow = new Row((JsonObject)jsonElement);
        clonedRow.setMetadata(this.row.getMetadata());
        DataControllerRequestRowImpl newRequest = new DataControllerRequestRowImpl(clonedRow, this.request);
        newRequest.headerMap.putAll(this.headerMap);
        newRequest.attributesMap.putAll(this.attributesMap);
        newRequest.cookies.putAll(this.cookies);
        return newRequest;
    }

    public String toString() {
        return "DataControllerRequestJSONImpl [headerMap=" + this.headerMap + ", jsonObject=" + this.row.toString() + ", session=" + this.session + ", attributesMap=" + this.attributesMap + "]";
    }

    public JsonObject getJsonObject() {
        return this.row.getJsonElement().getAsJsonObject();
    }

    public Row getRow() {
        return this.row;
    }

    private static Map<String, Object> getHeaders(HttpServletRequest request) {
        HashMap<String, Object> reqHeaders = new HashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                reqHeaders.put(key, request.getHeader(key));
            }
        }
        return reqHeaders;
    }
}

