/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.convertions;

import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.convertions.RowToJSON;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.exceptions.ProcessorInitializationException;
import com.konylabs.middleware.processor.Configuration;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.request.builder.ResultRow;
import org.apache.log4j.Logger;

public class JSONProcessor
implements Processor {
    private static final Logger LOGGER = Logger.getLogger(JSONProcessor.class);
    private boolean initialized_ = false;
    private String processorName_ = null;

    public void initConfig(String processorName, Configuration config) throws ProcessorInitializationException {
        if (this.initialized_) {
            return;
        }
        this.processorName_ = processorName;
        this.initialized_ = true;
    }

    public void execute(DataControllerRequest request, DataControllerResponse response) throws ProcessorException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Processor Name: " + this.processorName_));
        }
        if (request.getAttribute("passThruResults") != null) {
            LOGGER.debug((Object)"Pass through result is not null.");
        } else {
            Result result = (Result)request.getAttribute("results");
            if (result == null) {
                throw new ProcessorException(this.processorName_, "10002", "Result not available in the request context.");
            }
            String jsonString = null;
            try {
                jsonString = result instanceof ResultRow ? RowToJSON.convert((ResultRow)result, response) : ResultToJSON.convert((Result)result, (DataControllerResponse)response);
            }
            catch (Exception je) {
                LOGGER.error((Object)("JSON String syntax error" + je.getMessage()), (Throwable)je);
                throw new ProcessorException(this.processorName_, "10302", "JSON String syntax error.");
            }
            request.setAttribute("chunkedresults_json", (Object)jsonString);
        }
    }
}

