/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.convertions;

import com.konylabs.middleware.dataobject.AbstractRecord;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.ServiceOutput;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONToResult {
    public static void getResult(Result result, Service service, String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONToResult.makeResult(result, service, jsonObject);
    }

    private static void makeResult(Result result, Service service, JSONObject jsonObject) throws JSONException {
        ServiceOutput sout = service.getServiceOutput();
        ArrayList params = sout.getParams();
        int opstatus = jsonObject.getInt("opstatus");
        if (opstatus == 0) {
            result.addParam(new Param("opstatus", "0", "int"));
            JSONToResult.processParams((AbstractRecord)result, params, jsonObject);
            ArrayList datasets = sout.getDatasets();
            JSONToResult.makeResult(result, datasets, jsonObject);
        } else {
            result.addParam(new Param("opstatus", "" + opstatus, "int"));
            if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
                result.addParam(new Param("errmsg", jsonObject.getString("errmsg"), "string"));
            }
        }
        if (jsonObject.has("httpStatusCode")) {
            result.addParam(new Param("httpStatusCode", "" + jsonObject.getInt("httpStatusCode"), "int"));
        }
    }

    private static void processParams(AbstractRecord result, List<com.konylabs.middleware.registry.vo.Param> params, JSONObject jsonObject) {
        for (com.konylabs.middleware.registry.vo.Param param : params) {
            result.addParam(JSONToResult.buildParam(param, jsonObject));
        }
    }

    private static Param buildParam(com.konylabs.middleware.registry.vo.Param param, JSONObject jsonObject) {
        String type = param.getDataType();
        String key = param.getName();
        Param resultParam = new Param(key, type.toLowerCase());
        if ("string".equalsIgnoreCase(type)) {
            try {
                resultParam.setValue(jsonObject.getString(key));
            }
            catch (JSONException jex) {
                resultParam.setValue("");
            }
        } else if ("image".equalsIgnoreCase(type)) {
            try {
                resultParam.setValue(jsonObject.getString(key));
            }
            catch (JSONException jex) {
                resultParam.setValue("");
            }
        } else if ("double".equalsIgnoreCase(type)) {
            try {
                resultParam.setValue(jsonObject.getDouble(key) + "");
            }
            catch (JSONException jex) {
                resultParam.setValue("");
            }
        } else if ("int".equalsIgnoreCase(type)) {
            try {
                resultParam.setValue(jsonObject.getInt(key) + "");
            }
            catch (JSONException jex) {
                resultParam.setValue("");
            }
        } else if ("boolean".equalsIgnoreCase(type)) {
            try {
                resultParam.setValue(jsonObject.getBoolean(key) + "");
            }
            catch (JSONException jex) {
                resultParam.setValue("");
            }
        } else {
            resultParam.setType(type);
            try {
                resultParam.setValue(jsonObject.get(key) + "");
            }
            catch (JSONException jex) {
                resultParam.setValue("");
            }
        }
        return resultParam;
    }

    private static void makeResult(Result result, ArrayList<com.konylabs.middleware.registry.vo.Dataset> serviceDatasets, JSONObject jsonObject) throws JSONException {
        for (com.konylabs.middleware.registry.vo.Dataset serviceDataset : serviceDatasets) {
            String id = serviceDataset.getId();
            if (!jsonObject.has(id)) continue;
            JSONArray jsonArray = jsonObject.getJSONArray(id);
            Dataset resultDataset = new Dataset(id);
            for (int j = 0; j < jsonArray.length(); ++j) {
                JSONObject jobj = (JSONObject)jsonArray.get(j);
                Record resultRecord = new Record();
                JSONToResult.makeRecord(resultRecord, serviceDataset, jobj);
                resultDataset.addRecord(resultRecord);
            }
            result.addDataset(resultDataset);
        }
    }

    private static void makeRecord(Record resultRecord, com.konylabs.middleware.registry.vo.Dataset serviceDataset, JSONObject jsonObject) throws JSONException {
        JSONToResult.processParams((AbstractRecord)resultRecord, serviceDataset.getParams(), jsonObject);
        for (com.konylabs.middleware.registry.vo.Dataset innerServiceDataset : serviceDataset.getDatasets()) {
            String id = innerServiceDataset.getId();
            if (!jsonObject.has(id)) continue;
            JSONArray jsonArray = jsonObject.getJSONArray(id);
            Dataset innerDataset = new Dataset(id);
            for (int j = 0; j < jsonArray.length(); ++j) {
                JSONObject jobj = (JSONObject)jsonArray.get(j);
                Record innerRecord = new Record();
                JSONToResult.makeRecord(innerRecord, innerServiceDataset, jobj);
                innerDataset.addRecord(innerRecord);
            }
            resultRecord.addDataset(innerDataset);
        }
    }

    private JSONToResult() {
    }
}

