/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.dataprovider;

import com.kony.adapter.event.DataAdapterEventNotifier;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.common.DataProvider;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.utilities.CookieUtils;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public class DefaultDataProvider
implements DataProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultDataProvider.class);
    private final DataAdapterEventNotifier eventNotifier;

    public DefaultDataProvider(DataAdapterEventNotifier eventNotifier) {
        this.eventNotifier = eventNotifier;
    }

    public void execute(String urlString, DataControllerRequest request, DataControllerResponse response, String message, Map<String, String> headerMap, List<File> filesToUpload, HashMap configMap) throws ConnectorException {
        urlString = ConnectorUtils.updateQueryString(urlString, request, configMap);
        LOGGER.debug((Object)("URL string : " + urlString));
        String httpMethodStr = (String)configMap.get("http.method");
        HttpMethods httpMethod = StringUtils.isBlank((String)httpMethodStr) ? (StringUtils.isBlank((String)message) ? HttpMethods.GET : HttpMethods.POST) : HttpMethods.getHttpMethod((String)httpMethodStr);
        HttpRequestBase methodToExecute = httpMethod.getHttpRequest(urlString);
        if (httpMethod.isEntitySupported()) {
            methodToExecute = this.prepareHttpMethodWithEntity(request, (HttpEntityEnclosingRequestBase)methodToExecute, configMap, message, filesToUpload, headerMap);
        }
        this.executeHttpMethodAndGetResponse(request, response, configMap, headerMap, methodToExecute);
    }

    private HttpEntityEnclosingRequestBase prepareHttpMethodWithEntity(DataControllerRequest dataControllerRequest, HttpEntityEnclosingRequestBase enclosingRequestBase, Map<String, Object> configMap, String message, List<File> filesToUpload, Map<String, String> headerMap) throws ConnectorException {
        HttpEntity entity = this.prepareEntity(dataControllerRequest, configMap, message, filesToUpload, headerMap);
        if (entity != null) {
            enclosingRequestBase.setEntity(entity);
        }
        return enclosingRequestBase;
    }

    private void executeHttpMethodAndGetResponse(DataControllerRequest dataControllerRequest, DataControllerResponse dataControllerResponse, Map<String, Object> configMap, Map<String, String> headerMap, HttpRequestBase httpRequestBase) throws ConnectorException {
        String serviceId = dataControllerRequest.getParameter("serviceID");
        try {
            this.populateHeaders((HttpUriRequest)httpRequestBase, dataControllerRequest, headerMap);
            String requestEncoding = EncodeUtils.getEncodingOrDefault((Object)configMap.get("responseEncoding"));
            ConnectorUtils.executeHttpMethod(httpRequestBase, configMap, dataControllerRequest, dataControllerResponse, requestEncoding, this.eventNotifier);
            this.processStatusCodes(dataControllerRequest, dataControllerResponse, serviceId, configMap);
        }
        catch (IOException ex) {
            String errorMessage = "IOException occurred for service " + serviceId + " while obtaining response: " + ex.getMessage();
            MaskUtils.maskTrace((String)errorMessage, (Throwable)ex);
            throw new ConnectorException("DefaultDataProvider", "9001", errorMessage);
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            throw new ConnectorException("DefaultDataProvider", "9001", ex.getMessage());
        }
        finally {
            if (httpRequestBase != null) {
                httpRequestBase.releaseConnection();
            }
        }
    }

    private void processStatusCodes(DataControllerRequest request, DataControllerResponse response, String serviceId, Map<String, Object> configMap) throws ConnectorException {
        boolean isResPassThru = Boolean.parseBoolean(configMap.get("isResPassThru") != null ? configMap.get("isResPassThru").toString() : "false");
        if (!isResPassThru) {
            int statusCode = response.getStatusCode();
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 598: 
                case 599: {
                    request.setAttribute("opstatus", (Object)"0");
                    break;
                }
                default: {
                    request.setAttribute("opstatus", (Object)"8009");
                    if (StringUtils.isBlank((String)response.getResponse())) {
                        throw new ConnectorException("DefaultDataProvider", "8009", statusCode, "Request unsuccessful for service " + serviceId + ", server responded with status code " + statusCode);
                    }
                    request.setAttribute("errmsg", (Object)("Request unsuccessful for service " + serviceId + ", server responded with status code " + statusCode));
                }
            }
        }
    }

    private void populateHeaders(HttpUriRequest request, DataControllerRequest dcRequest, Map<String, String> headerMap) {
        for (String key : headerMap.keySet()) {
            if (CacheUtils.isSesionDistributed().booleanValue() && "Cookie".equals(key)) {
                LOGGER.debug((Object)"Session is distributed");
                CookieUtils.checkCookiesInRequest(dcRequest, headerMap);
                continue;
            }
            String headerValue = headerMap.get(key);
            String string = headerValue = StringUtils.isNotBlank((String)headerValue) ? headerValue.replace('\r', ' ').replace('\n', ' ') : headerValue;
            if ("content-type".equalsIgnoreCase(key) && (StringUtils.isBlank((String)headerValue) || "NULL".equalsIgnoreCase(headerValue))) continue;
            request.addHeader(key, headerValue);
        }
        MiddlewareUtils.removeContentTypeHeaderForGetIfRequested(request, dcRequest);
    }

    private HttpEntity buildMessageEntity(DataControllerRequest request, String message, Map<String, Object> configMap, Map<String, String> headerMap) throws ConnectorException {
        InputStreamEntity entity = null;
        String requestEncoding = EncodeUtils.getEncodingOrDefault((Object)configMap.get("responseEncoding"));
        boolean isReqPassThru = Boolean.parseBoolean(configMap.get("isReqPassThru").toString());
        if (!isReqPassThru) {
            String contentType = MiddlewareUtils.getContentType(headerMap, "text/xml");
            if (StringUtils.isNotBlank((String)message)) {
                int eqIdx = message.indexOf("=");
                int lsIdx = message.indexOf("<");
                if (!(eqIdx == -1 || eqIdx >= lsIdx && lsIdx != -1 || "application/json".equals(contentType))) {
                    String paramDelimiter = StringUtils.isEmpty((String)request.getParameter("paramdelimiter")) ? "&" : request.getParameter("paramdelimiter");
                    String[] nameValues = StringUtils.split((String)message, (String)paramDelimiter);
                    if (nameValues != null && nameValues.length > 0) {
                        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(nameValues.length);
                        for (int idx = 0; idx < nameValues.length; ++idx) {
                            int firstEqualIdx = nameValues[idx].indexOf("=");
                            if (firstEqualIdx == -1) continue;
                            String name = nameValues[idx].substring(0, firstEqualIdx);
                            String value = nameValues[idx].substring(firstEqualIdx + 1);
                            MaskUtils.logDebugWithMasking((String)"Post param value", (String)name, (String)value);
                            BasicNameValuePair parameter = new BasicNameValuePair(name, value);
                            parameters.add(parameter);
                        }
                        try {
                            entity = new UrlEncodedFormEntity(parameters, requestEncoding);
                        }
                        catch (UnsupportedEncodingException e) {
                            MaskUtils.maskTrace((String)e.getMessage(), (Throwable)e);
                            throw new ConnectorException("DefaultDataProvider", "9001", e.getMessage());
                        }
                    }
                } else {
                    StringEntity stringEntity = new StringEntity(message, Charset.forName(requestEncoding));
                    if (!contentType.contains("charset")) {
                        contentType = contentType + "; charset=" + requestEncoding;
                    }
                    stringEntity.setContentType(contentType);
                    entity = stringEntity;
                }
            }
        } else {
            entity = new InputStreamEntity((InputStream)request.getAttribute("passThruHttpEntity"), -1L);
        }
        return entity;
    }

    private HttpEntity prepareEntity(DataControllerRequest request, Map<String, Object> configMap, String message, List<File> filesToUpload, Map<String, String> headerMap) throws ConnectorException {
        if (filesToUpload.size() > 0) {
            MultipartEntityBuilder multipartBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (File file : filesToUpload) {
                FileBody fileBody = new FileBody(file);
                multipartBuilder.addPart(file.getName(), (ContentBody)fileBody);
            }
            return multipartBuilder.build();
        }
        return this.buildMessageEntity(request, message, configMap, headerMap);
    }
}

