/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.dataprovider.stub;

import com.github.vincentrussell.json.datagenerator.functions.impl.FunctionUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

abstract class CustomDataTypeStub {
    private static final Logger LOGGER = Logger.getLogger(CustomDataTypeStub.class);
    private JsonArray customDataRows;

    CustomDataTypeStub() {
    }

    protected abstract String getResourceName();

    protected String getRandomRow(String ... args) {
        this.loadDataSafely();
        if (args != null && args.length == 0) {
            return this.customDataRows.toString();
        }
        int randomNumber = FunctionUtils.getRandomInteger((Integer)0, (Integer)this.customDataRows.size());
        return this.getSelectedFields(this.customDataRows.get(randomNumber).getAsJsonObject(), args);
    }

    private static JsonArray loadData(String resourceName) {
        String jsonString = "[{\"error\":\"Unable to read data\"}]";
        try (InputStream resourceStream = CustomDataTypeStub.class.getClassLoader().getResourceAsStream(resourceName);){
            if (resourceStream != null) {
                jsonString = IOUtils.toString((InputStream)resourceStream);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Failed to load stub data file " + resourceName), (Throwable)e);
        }
        return new JsonParser().parse(jsonString).getAsJsonArray();
    }

    private String getSelectedFields(JsonObject jsonObject, String ... args) {
        if (args != null && args.length != 0) {
            if (args.length == 1 && jsonObject.has(args[0])) {
                return jsonObject.get(args[0]).getAsString();
            }
            JsonObject jsonObjectToReturn = new JsonObject();
            for (String arg : args) {
                if (!jsonObject.has(arg)) continue;
                jsonObjectToReturn.add(arg, jsonObject.get(arg));
            }
            return jsonObjectToReturn.toString();
        }
        return jsonObject.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSafely() {
        if (this.customDataRows == null) {
            CustomDataTypeStub customDataTypeStub = this;
            synchronized (customDataTypeStub) {
                if (this.customDataRows == null) {
                    this.customDataRows = CustomDataTypeStub.loadData(this.getResourceName());
                }
            }
        }
    }
}

