/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.dataprovider.stub;

import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventType;
import com.kony.adapter.event.EventDetail;
import com.konylabs.middleware.common.DataProvider;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataprovider.stub.RegisterCustomDataTypeStub;
import com.konylabs.middleware.dataprovider.stub.StubEventDetail;
import com.konylabs.middleware.dataprovider.stub.StubGenerator;
import com.konylabs.middleware.dataprovider.stub.StubRequestContextHolder;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Service;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StubDataProvider
implements DataProvider {
    private static final Logger LOGGER = Logger.getLogger(StubDataProvider.class);
    private final DataAdapterEventNotifier eventNotifier;
    private final Map<String, Object> inputMap;
    private final Service service;

    public StubDataProvider(DataAdapterEventNotifier eventNotifier, Map<String, Object> inputMap, Service service) {
        this.eventNotifier = eventNotifier;
        this.inputMap = inputMap;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String url, DataControllerRequest request, DataControllerResponse response, String template, Map<String, String> headerMap, List<File> filesToUpload, HashMap configMap) throws ConnectorException {
        String stubInputTemplate = (String)configMap.get("stub.input.template");
        DataAdapterEvent requestEvent = new DataAdapterEvent(DataAdapterEventType.IntegrationServiceInput);
        requestEvent.addEventDetails("Request", (EventDetail)new StubEventDetail("Payload", stubInputTemplate));
        this.eventNotifier.notify(requestEvent);
        try {
            LOGGER.warn((Object)("INFO - Generating stub reponse for service: " + this.service.getId()));
            StubRequestContextHolder.setHeaders(headerMap);
            StubRequestContextHolder.setInputParams(this.inputMap);
            String stubbedResponse = StubGenerator.generateStubData(stubInputTemplate);
            response.setResponse(stubbedResponse);
            response.setStatusCode(200);
            response.getDeviceHeaders().put("X-Kony-Stub-Response", String.valueOf(true));
            DataAdapterEvent responseEvent = new DataAdapterEvent(DataAdapterEventType.IntegrationServiceOutput);
            responseEvent.addEventDetails("Response", (EventDetail)new StubEventDetail("ResponseBody", stubbedResponse));
            this.eventNotifier.notify(responseEvent);
        }
        finally {
            StubRequestContextHolder.removeAll();
        }
    }

    static {
        RegisterCustomDataTypeStub.registerCustomDataTypeStub();
    }
}

