/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.dataprovider.stub;

import com.github.vincentrussell.json.datagenerator.impl.JsonDataGeneratorImpl;
import com.konylabs.middleware.exceptions.ConnectorException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class StubGenerator {
    private static final Logger LOGGER = Logger.getLogger(StubGenerator.class);

    public static String generateStubData(String inputTemplate) throws ConnectorException {
        if (StringUtils.isBlank((String)inputTemplate)) {
            LOGGER.error((Object)"Stub input template is null or empty.");
            throw new ConnectorException("Stub DataProvider", "8060", "Stub input template is null or empty.");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Trying to generate stub data using template: " + inputTemplate));
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonDataGeneratorImpl parser = new JsonDataGeneratorImpl();
            parser.generateTestDataJson(inputTemplate, (OutputStream)outputStream);
            String stubbedData = outputStream.toString(StandardCharsets.UTF_8.name());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Generated stubbed data: " + stubbedData));
            }
            return stubbedData;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while generating stub data from template.", (Throwable)e);
            throw new ConnectorException("Stub DataProvider", "8060", "Failed to generate stub data", (Throwable)e);
        }
    }

    private StubGenerator() {
    }
}

