/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.dataprovider.stub;

import java.util.Map;

public final class StubRequestContextHolder {
    private static final ThreadLocal<Map<String, String>> HEADERS_THREAD_LOCAL = new InheritableThreadLocal<Map<String, String>>();
    private static final ThreadLocal<Map<String, Object>> INPUT_PARAMS_THREAD_LOCAL = new InheritableThreadLocal<Map<String, Object>>();

    public static void setHeaders(Map<String, String> headersMap) {
        HEADERS_THREAD_LOCAL.set(headersMap);
    }

    public static String getHeader(String headerName) {
        Map<String, String> headers = HEADERS_THREAD_LOCAL.get();
        return headers == null ? "" : headers.get(headerName);
    }

    public static void setInputParams(Map<String, Object> inputMap) {
        INPUT_PARAMS_THREAD_LOCAL.set(inputMap);
    }

    public static Object getInputParam(String paramName) {
        Map<String, Object> inputParamMap = INPUT_PARAMS_THREAD_LOCAL.get();
        return inputParamMap == null ? "" : inputParamMap.get(paramName);
    }

    public static void removeAll() {
        HEADERS_THREAD_LOCAL.remove();
        INPUT_PARAMS_THREAD_LOCAL.remove();
    }

    private StubRequestContextHolder() {
    }
}

