/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.dataprovider.stub;

import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataprovider.stub.StubConfigProperties;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class StubUtils {
    private static final String NAME_SEPARATOR = "_";

    public static boolean isStubDataProviderEnabled(DataControllerRequest request, Map<String, Object> configMap) {
        boolean isStubResponseDisabledGlobally = (Boolean)StubConfigProperties.DISABLE_ALL_STUB_RESPONSE.getFromConfig();
        if (isStubResponseDisabledGlobally) {
            return false;
        }
        String stubRequestHeader = request.getHeader("X-Kony-Stub-Request");
        return StringUtils.isNotBlank((String)stubRequestHeader) ? Boolean.valueOf(stubRequestHeader) : Boolean.valueOf((String)configMap.get("stub.response"));
    }

    public static void populateStubInputTemplate(ServiceMetadata serviceMetadata, DataControllerRequest request, Map<String, Object> configMap) {
        if (StubUtils.isStubDataProviderEnabled(request, configMap) || StubUtils.isStubConnectorEnabled(serviceMetadata.getService().getServiceType())) {
            String stubAssetName = serviceMetadata.getAppId() + NAME_SEPARATOR + StringUtils.replace((String)serviceMetadata.getVersion(), (String)".", (String)NAME_SEPARATOR) + NAME_SEPARATOR + serviceMetadata.getService().getId() + ".stub";
            String stubInputTemplate = (String)serviceMetadata.getAppMetadata().getAssetByName(AssetType.STUB.getType(), stubAssetName);
            configMap.put("stub.input.template", stubInputTemplate);
        }
    }

    private static boolean isStubConnectorEnabled(String serviceType) {
        return MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.stubConnector.toString().equalsIgnoreCase(serviceType);
    }

    private StubUtils() {
    }
}

