/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.datasourcelogs;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.EventDetail;
import com.kony.mobilefabric.logger.DiagnosticContext;
import com.konylabs.middleware.config.DevicePayloadLogger;
import com.konylabs.middleware.datasourcelogs.DeviceRequestData;
import com.konylabs.middleware.datasourcelogs.DeviceResponseData;
import com.konylabs.middleware.datasourcelogs.LogDataSourceData;
import com.konylabs.middleware.datasourcelogs.LogDeviceRequestData;
import com.konylabs.middleware.datasourcelogs.LogDeviceResponseData;
import com.konylabs.middleware.event.impl.HttpRequestEventImpl;
import com.konylabs.middleware.request.builder.PayloadParserUtil;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class DiagnosticLogService {
    private static final Logger LOGGER = Logger.getLogger(DiagnosticLogService.class);

    public static void saveLogMetaIntoNDC(String key, String value) {
        ThreadContext.put((String)key, (String)value);
    }

    public static void logEvent(DataAdapterEvent event) {
        Map eventDetails = event.getEventDetails();
        HashMap evenDetailsInString = new HashMap();
        for (Map.Entry eventDetail : eventDetails.entrySet()) {
            if (eventDetail.getValue() instanceof HttpRequestEventImpl) continue;
            JsonElement evenDetailInJson = ((EventDetail)eventDetail.getValue()).toJson();
            evenDetailsInString.put(eventDetail.getKey(), PayloadParserUtil.getEntryValueBasedOnType(evenDetailInJson));
        }
        LogDataSourceData.log(new Gson().toJson(evenDetailsInString));
    }

    public static void logDeviceRequestData(DeviceRequestData deviceRequestData) {
        LOGGER.debug((Object)"Logging device request data");
        DevicePayloadLogger.log("Device Request URL : %s", deviceRequestData.getRequestUrl());
        DevicePayloadLogger.log("Device Payload Query Parameters : %s", deviceRequestData.getQueryParams());
        DevicePayloadLogger.log("Device Payload Raw Request Body : %s", deviceRequestData.getBody());
        DevicePayloadLogger.log("Device Payload Request Headers : %s", deviceRequestData.getHeaders());
        HashMap<String, String> mapMessage = new HashMap<String, String>();
        mapMessage.put("payload", new Gson().toJson((Object)deviceRequestData));
        mapMessage.put("requestSize", Integer.toString(deviceRequestData.getBody().length()));
        LogDeviceRequestData.log(mapMessage);
    }

    public static JsonObject convertToJSONQuietly(Object responseObj) {
        try {
            if (responseObj instanceof String) {
                return new JsonParser().parse((String)responseObj).getAsJsonObject();
            }
            if (responseObj instanceof JsonObject) {
                return (JsonObject)responseObj;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception while parsing object to json" + ex.getMessage()));
        }
        return null;
    }

    public static void logDeviceResponseData(DeviceResponseData deviceResponseData) {
        LogDeviceResponseData.buildAndLog(deviceResponseData);
    }

    public static void setDiagnosticContextInfo(HttpServletRequest httpServletRequest, boolean isRequestPassthrough) {
        String requestID = StringUtils.isNotBlank((CharSequence)DiagnosticContext.getRequestId()) ? DiagnosticContext.getRequestId() : MiddlewareUtils.getRequestId(httpServletRequest);
        DiagnosticLogService.saveLogMetaIntoNDC("requestID", requestID);
        DiagnosticLogService.saveLogMetaIntoNDC("httpMethod", httpServletRequest.getMethod());
        DiagnosticLogService.saveLogMetaIntoNDC("deviceID", MiddlewareUtils.getDeviceID(httpServletRequest, isRequestPassthrough));
    }

    public static boolean isTraceLogsEnabled() {
        return LogDeviceRequestData.isLogDeviceRequestDataEnabled();
    }

    public static void initDeviceRequestResponseLogBean(ServletRequest request) {
        LOGGER.debug((Object)"Inside setDeviceRequestResponseLogBean method");
        if (request.getAttribute("DeviceReqLogBean") == null) {
            LOGGER.debug((Object)"Device request log bean is empty; adding a new bean");
            request.setAttribute("DeviceReqLogBean", (Object)new DeviceRequestData());
        }
        if (request.getAttribute("DeviceResLogBean") == null) {
            LOGGER.debug((Object)"Device response log bean is empty; adding a new bean");
            request.setAttribute("DeviceResLogBean", (Object)new DeviceResponseData());
        }
        LOGGER.debug((Object)"Exiting setDeviceRequestResponseLogBean method");
    }
}

