/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.datasourcelogs;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.konylabs.middleware.config.DevicePayloadLogger;
import com.konylabs.middleware.datasourcelogs.DeviceResponseData;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;

public class LogDeviceResponseData {
    private static final Logger LOGGER = LogManager.getLogger(LogDeviceResponseData.class);

    public static void log(Map<String, String> mapMessage) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Message)new MapMessage(mapMessage));
        }
    }

    public static void buildAndLog(DeviceResponseData deviceResponseData) {
        if (LOGGER.isDebugEnabled()) {
            HashMap<String, String> mapMessage = new HashMap<String, String>();
            deviceResponseData.getHeaders().putAll(MiddlewareUtils.getDefaltHeaders());
            DevicePayloadLogger.log("Device Payload Response Headers : %s", MiddlewareUtils.getFormattedStringFromHeadersMap(deviceResponseData.getHeaders()));
            DevicePayloadLogger.log("Device Payload Response Body : %s", deviceResponseData.getBody());
            String opstatus = LogDeviceResponseData.getOpstatusFromDeviceResponseData(deviceResponseData);
            if (opstatus != null) {
                mapMessage.put("opstatus", opstatus);
            }
            String response = new Gson().toJson((Object)deviceResponseData);
            mapMessage.put("payload", response);
            mapMessage.put("responseSize", Integer.toString(response.length()));
            LogDeviceResponseData.log(mapMessage);
        }
    }

    public static String getOpstatusFromDeviceResponseData(DeviceResponseData deviceResponseData) {
        String opstatus = null;
        if (deviceResponseData.getBody().has("opstatus")) {
            opstatus = deviceResponseData.getBody().get("opstatus").getAsString();
        } else if (deviceResponseData.getBody().has("Metadata")) {
            JsonObject metadata = deviceResponseData.getBody().get("Metadata").getAsJsonObject();
            opstatus = metadata.get("opstatus").getAsString();
        }
        return opstatus;
    }
}

