/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.devicedb;

import com.konylabs.middleware.devicedb.DeviceDBException;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public final class DBUtil {
    private static final Logger LOGGER = Logger.getLogger(DBUtil.class);
    private static boolean initialized_ = false;
    private static String database_ = null;
    private static boolean started_ = false;
    private static DataSource datasource_ = null;

    public static void init() throws DeviceDBException {
        if (initialized_) {
            return;
        }
        DBUtil.startDatabase();
        initialized_ = true;
    }

    private static void startDatabase() throws DeviceDBException {
        LOGGER.debug((Object)"Setting up the device db");
        if (started_) {
            LOGGER.debug((Object)(database_ + "is already started"));
            return;
        }
        if (datasource_ == null) {
            DBUtil.setupDataSource();
        }
        started_ = false;
    }

    private static void setupDataSource() throws DeviceDBException {
        try {
            datasource_ = MiddlewareDbManager.getDataSource((String)"konydeviceDS");
        }
        catch (Exception e) {
            LOGGER.fatal((Object)"Exception creating the device db datasource", (Throwable)e);
            throw new DeviceDBException("9010", "Exception creating the device db datasource");
        }
    }

    public static Connection getConnection() throws DeviceDBException {
        Connection conn = null;
        try {
            conn = datasource_.getConnection();
        }
        catch (SQLException sqle) {
            LOGGER.error((Object)"DBUtil error:", (Throwable)sqle);
            throw new DeviceDBException("9008", "Can not get an active connection to the database.");
        }
        return conn;
    }

    public static ResultSet execQuery(Connection conn, PreparedStatement stmnt) throws DeviceDBException {
        try {
            ResultSet rs = stmnt.executeQuery();
            return rs;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Cannot execute the query", (Throwable)ex);
            throw new DeviceDBException("9009", "Cannot execute the query");
        }
    }

    private DBUtil() {
    }
}

