/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.devicedb;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.devicedb.DBUtil;
import com.konylabs.middleware.devicedb.DeviceDBException;
import com.konylabs.middleware.devicedb.DeviceProfile;
import com.konylabs.middleware.devicedb.IDeviceDB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class KonyDeviceDB
implements IDeviceDB {
    static KonyDeviceDB deviceDB = null;
    private static final Logger logger = Logger.getLogger(KonyDeviceDB.class);
    static final String DEVICE_PROFILE_FOR_USER_AGENT_QUERY = "SELECT a.UAGENTID , a.OS,a.USES_STYLUS, a.USERAGENT,b.NAME,b.VALUE FROM DBCLIENT.USERAGENTS a , DBCLIENT.ATTRIBUTES b WHERE a.UAGENTID = b.UAGENTID and a.USERAGENT = ?";
    static final String DEVICE_PROFILE_FOR_DEVICE_ID_QUERY = "SELECT a.UAGENTID , a.OS,a.USES_STYLUS, a.USERAGENT,b.NAME,b.VALUE FROM DBCLIENT.USERAGENTS a , DBCLIENT.ATTRIBUTES b WHERE a.UAGENTID = b.UAGENTID AND a.UAGENTID = ?";
    public static final String COLUMN_DEVICEID = "UAGENTID";
    public static final String COLUMN_USES_STYLUS = "USES_STYLUS";
    public static final String COLUMN_OS = "OS";
    public static final String ATTRIBUTE_NAME = "NAME";
    public static final String ATTRIBUTE_VALUE = "VALUE";
    public static final String ATTRIBUTE_OS_DETAILS = "osd";
    public static final String ATTRIBUTE_MEMORY = "mem";
    public static final String ATTRIBUTE_OTA_JAD_SIGNING = "ota_jad_signing";
    public static final String ATTRIBUTE_OTA_JAR_ONLY = "ota_jar_only";
    public static final String ATTRIBUTE_SPECIAL_JAD_ATTRIBUTES = "special_jad_attributes";
    public static final String ATTRIBUTE_IMAGE_FORMAT_SUPPORT = "img";
    public static final String ATTRIBUTE_SUPPORTS_NOKIA_UI = "supports_nokia_ui";
    public static final String ATTRIBUTE_JAR_ARCHIVE_FORMAT = "jar_archive_format";
    public static final String ATTRIBUTE_BLACKBERRY_ISTRACKWHEEL = "blackberry_istrackwheel";
    public static final String OS_J2ME = "j2me";
    public static final String OS_BLACKBERRY = "blackberry";
    public static final String OS_WINDOWS = "windows";
    public static final String OS_BREW = "brew";
    public static final String OS_ANDROID = "android";

    private KonyDeviceDB() {
    }

    public static KonyDeviceDB getInstance() {
        if (deviceDB == null) {
            deviceDB = new KonyDeviceDB();
        }
        return deviceDB;
    }

    public static boolean init() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Start Initializing the device database");
            }
            DBUtil.init();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Completed Initializing the device database");
            }
            return true;
        }
        catch (DeviceDBException e) {
            logger.error((Object)"Error initializing the db pool", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DeviceProfile getDeviceProfileForUserAgent(String userAgent) {
        ResultSet rs;
        Connection conn;
        PreparedStatement stmt;
        DeviceProfile profile;
        block6: {
            profile = null;
            stmt = null;
            conn = null;
            rs = null;
            try {
                conn = DBUtil.getConnection();
                if (conn == null) break block6;
                stmt = conn.prepareStatement(DEVICE_PROFILE_FOR_USER_AGENT_QUERY);
                stmt.setString(1, userAgent);
                rs = DBUtil.execQuery(conn, stmt);
                profile = this.getDeviceProfile(rs);
            }
            catch (SQLException se) {
                logger.error((Object)"Error executing the query : ", (Throwable)se);
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
            }
            catch (DeviceDBException ddbe) {
                logger.error((Object)"Error executing the query : ", (Throwable)ddbe);
                {
                    catch (Throwable throwable) {
                        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
                        throw throwable;
                    }
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DeviceProfile getDeviceProfileForDeviceID(String deviceID) {
        DeviceProfile profile = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            String query = DEVICE_PROFILE_FOR_DEVICE_ID_QUERY + deviceID;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Firing the query " + query));
            }
            conn = DBUtil.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            profile = this.getDeviceProfile(rs);
        }
        catch (DeviceDBException sqe) {
            logger.error((Object)"Error executing the query : ", (Throwable)sqe);
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        }
        catch (SQLException ex) {
            logger.error((Object)"Error executing the query : ", (Throwable)ex);
            {
                catch (Throwable throwable) {
                    Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                    throw throwable;
                }
            }
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return profile;
    }

    private DeviceProfile getDeviceProfile(ResultSet rs) {
        DeviceProfile profile = null;
        String tempName = null;
        String tempValue = null;
        try {
            if (rs != null) {
                while (rs.next()) {
                    if (profile == null) {
                        profile = new DeviceProfile();
                        profile.put(COLUMN_DEVICEID, rs.getString(COLUMN_DEVICEID));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Device ID : " + profile.get(COLUMN_DEVICEID)));
                        }
                        profile.put(COLUMN_OS, rs.getString(COLUMN_OS));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Device OS : " + profile.get(COLUMN_OS)));
                        }
                        profile.put(COLUMN_USES_STYLUS, rs.getString(COLUMN_USES_STYLUS));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Device Uses Stylus : " + profile.get(COLUMN_USES_STYLUS)));
                        }
                    }
                    tempName = rs.getString(ATTRIBUTE_NAME);
                    tempValue = rs.getString(ATTRIBUTE_VALUE);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Device Attribute : " + tempName + " Value :" + tempValue));
                    }
                    profile.put(tempName, tempValue);
                }
            }
        }
        catch (SQLException sqe) {
            logger.error((Object)"Error executing the query : ", (Throwable)sqe);
        }
        return profile;
    }
}

