/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.entry;

import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.common.KHttpServletResponseWrapper;
import com.konylabs.middleware.entry.utils.RequestForwardUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ForwardServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ForwardServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)"Inside forward servlet.");
        KHttpServletRequestWrapper requestWrapper = MiddlewareUtils.getKHttpServletRequestWrapper(request, false);
        KHttpServletResponseWrapper responseWrapper = MiddlewareUtils.getKHttpServletResponseWrapper(response);
        String appId = requestWrapper.getParameter("appID");
        String serviceId = requestWrapper.getParameter("serviceID");
        String forwardURL = RequestForwardUtils.getForwardingURL(appId, serviceId);
        try {
            LOGGER.debug((Object)String.format("Forwarding url : [%s]", forwardURL));
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(forwardURL);
            dispatcher.forward((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        catch (Exception e) {
            LOGGER.error((Object)String.format("Unable to forward the request with URL : [%s]", forwardURL), (Throwable)e);
            RequestForwardUtils.flushErrorResponse((HttpServletResponse)responseWrapper, forwardURL);
        }
        LOGGER.debug((Object)"Exit forward servlet.");
    }
}

