/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.entry;

import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.controller.impl.DataControllerImpl;
import com.konylabs.middleware.datasourcelogs.DeviceResponseData;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.servlet.AbstractServlet;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class MWServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(MWServlet.class);
    private static final long serialVersionUID = 1L;
    private static DataController dc;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (dc == null) {
            dc = DataController.InstanceManager.getInstance();
            try {
                String fileName = ConfigUtility.getProperty((String)"controller.deffile");
                fileName = ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/" + fileName;
                dc.init(fileName);
            }
            catch (ControllerInitializationException cie) {
                MaskUtils.maskTrace((String)("\n IN MWServlet - Controller Initialization Exception. Error code: " + cie.getErrorCode() + "\n"), (Throwable)cie);
                throw new ServletException();
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (request.getRequestURI() != null && request.getRequestURI().endsWith(".html")) {
                this.checkForHTMLURI(request, response);
            } else {
                this.executeRequest(request, response);
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"caught throwable at top level", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForHTMLURI(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream output;
        InputStream in;
        block3: {
            in = null;
            output = null;
            try {
                output = response.getOutputStream();
                int startIndex = request.getRequestURI().lastIndexOf("/");
                in = request.getSession().getServletContext().getResourceAsStream(request.getRequestURI().substring(startIndex));
                if (in != null) {
                    byte[] buffer = new byte[in.available()];
                    in.read(buffer);
                    response.setContentType("text/html");
                    response.setContentLength(buffer.length);
                    output.write(buffer, 0, buffer.length);
                    break block3;
                }
                output.write("Sorry the page you are looking for does not exist.".getBytes());
                response.setStatus(404);
            }
            catch (Throwable throwable) {
                Closer.closeQuietly(in);
                Closer.closeQuietly((Closeable)output);
                throw throwable;
            }
        }
        Closer.closeQuietly((Closeable)in);
        Closer.closeQuietly((Closeable)output);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.executeRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PrintWriter pw = null;
        if (request.getRequestURI() != null && request.getRequestURI().endsWith(".html")) {
            this.checkForHTMLURI(request, response);
        } else {
            LOGGER.debug((Object)"\n IN MWServlet Method POST ------- \n");
            LOGGER.debug((Object)("In Post - Length " + request.getContentLength()));
            request.removeAttribute("REQUEST_PAYLOAD");
            request.removeAttribute("REQUEST_PAYLOAD_UPLOAD_FILES");
            try {
                String characterEncoding = request.getCharacterEncoding();
                LOGGER.debug((Object)("Request character encoding :" + characterEncoding));
                if (characterEncoding == null) {
                    characterEncoding = "utf-8";
                }
                LOGGER.debug((Object)("Setting the response encoding to :" + characterEncoding));
                String json = null;
                try {
                    json = DataControllerImpl.processHttpRequest(request, response);
                }
                catch (ControllerInitializationException ex) {
                    throw new ServletException("Generic error has occurred");
                }
                if (json != null) {
                    response.setCharacterEncoding(characterEncoding);
                    int contentLength = json.getBytes(characterEncoding).length;
                    response.setStatus(200);
                    response.setContentLength(contentLength);
                    response.setHeader("Content-Length", contentLength + "");
                    response.setContentType(MiddlewareUtils.getContentType());
                    response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                    response.setHeader("Pragma", "no-cache");
                    if (CacheUtils.isSesionDistributed().booleanValue()) {
                        Map headerMap;
                        LOGGER.debug((Object)"Session is distributed");
                        List cookies = (List)request.getAttribute("set_response_cookies_list");
                        if (cookies != null && !cookies.isEmpty()) {
                            for (Cookie cookie : cookies) {
                                response.addCookie(cookie);
                            }
                        }
                        if ((headerMap = (Map)request.getAttribute("set_response_header_map")) != null && !headerMap.isEmpty()) {
                            for (String key : headerMap.keySet()) {
                                if (key == null || headerMap.get(key) == null) continue;
                                response.setHeader(key, (String)headerMap.get(key));
                            }
                        }
                    }
                    DeviceResponseData deviceResponseData = (DeviceResponseData)request.getAttribute("DeviceResLogBean");
                    deviceResponseData.setBody(DiagnosticLogService.convertToJSONQuietly(json));
                    DiagnosticLogService.logDeviceResponseData(deviceResponseData);
                    pw = response.getWriter();
                    pw.write(json);
                    pw.flush();
                }
            }
            catch (IOException ex) {
                if (ConfigUtility.getBoolean((String)"mask.trace", (boolean)false)) {
                    MaskUtils.maskTrace((String)"IO Exception encountered", (Throwable)ex);
                } else {
                    LOGGER.error((Object)"IO Exception encountered", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (ConfigUtility.getBoolean((String)"mask.trace", (boolean)false)) {
                    MaskUtils.maskTrace((String)"xception encountered in MWServlet : ", (Throwable)ex);
                } else {
                    LOGGER.error((Object)"Exception encountered in MWServlet : ", (Throwable)ex);
                }
            }
            catch (Throwable t) {
                if (!ConfigUtility.getBoolean((String)"mask.trace", (boolean)false)) {
                    LOGGER.error((Object)"caught throwable at top level", t);
                } else {
                    LOGGER.error((Object)"caught throwable at top level");
                }
            }
            finally {
                Closer.closeQuietly(pw);
            }
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.executeRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.executeRequest(request, response);
    }

    public void destroy() {
    }
}

