/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.entry.utils;

import com.google.gson.JsonObject;
import com.konylabs.middleware.common.IntegrationValidationListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class RequestForwardUtils {
    private static final Logger LOGGER = Logger.getLogger(RequestForwardUtils.class);

    private RequestForwardUtils() {
    }

    public static String getForwardingURL(String appID, String serviceID) {
        String migrationURL;
        StringBuilder forwardURL = new StringBuilder("/");
        Properties migrationProperties = IntegrationValidationListener.getMigrationProperties();
        String string = migrationURL = migrationProperties != null ? migrationProperties.getProperty(appID + "/" + serviceID) : null;
        if (StringUtils.isNotBlank(migrationURL)) {
            forwardURL.append(migrationURL);
        } else if (StringUtils.isNotBlank((String)appID) && StringUtils.isNotBlank((String)serviceID)) {
            LOGGER.debug((Object)String.format("MigrationURL not found with the key [%s]", appID + "/" + serviceID));
            forwardURL.append(appID).append("/").append(serviceID);
        }
        return forwardURL.toString();
    }

    public static void flushErrorResponse(HttpServletResponse response, String forwardURL) throws IOException {
        try (PrintWriter writer = response.getWriter();){
            JsonObject errJsonObject = new JsonObject();
            String errMsg = String.format("Unable to forward the request with URL : [%s]", forwardURL);
            errJsonObject.addProperty("errmsg", errMsg);
            response.setStatus(500);
            writer.append(errJsonObject.toString());
            writer.flush();
        }
    }
}

