/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.environment;

import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.EnvironmentDao;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class EnvironmentFactory {
    private static Environment environment = null;
    private static final Logger LOGGER = Logger.getLogger(EnvironmentFactory.class);

    public static Environment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(Environment environment) {
        EnvironmentFactory.environment = environment;
    }

    public static Environment getEnvironmentInstance(EnvironmentConfigBean configBean) {
        try {
            if (EnvironmentFactory.getEnvironment() == null) {
                LOGGER.debug((Object)"Loading configuration details from database in initialization");
                boolean cloudMode = Boolean.valueOf(System.getProperty("CLOUD_MODE")) != false || "S3".equalsIgnoreCase(System.getProperty("STORAGE_TYPE"));
                String envClassName = "com.konylabs.middleware.environment.impl.OnPremiseMobileFabricEnvironment";
                if (cloudMode) {
                    LOGGER.debug((Object)"Environment instance is AmazonS3Environment");
                    envClassName = "com.konylabs.middleware.environment.impl.AmazonMobileFabricEnvironment";
                } else if (!((EnvironmentDao)DAOFactory.getDAO(EnvironmentDao.class)).isEnvironmentRegistered(configBean)) {
                    LOGGER.debug((Object)"Enviornment instance is Default Environment");
                    envClassName = "com.konylabs.middleware.environment.impl.DefaultEnvironment";
                }
                LOGGER.debug((Object)String.format("Environment instance class name : %s", envClassName));
                Class<?> cl = Class.forName(envClassName);
                Constructor<?> cons = cl.getConstructor(EnvironmentConfigBean.class);
                environment = (Environment)cons.newInstance(configBean);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Caught Error Instantiating the Environment", (Throwable)e);
        }
        return environment;
    }

    public static Environment reloadEnvironment(EnvironmentConfigBean configBean) {
        EnvironmentFactory.setEnvironment(null);
        return EnvironmentFactory.getEnvironmentInstance(configBean);
    }
}

