/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.environment;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.ProxyUtil;
import com.konylabs.middleware.connectors.SSLProperties;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public final class HttpMethodUtils {
    private static final Logger LOGGER = Logger.getLogger(HttpMethodUtils.class);
    private static CloseableHttpClient httpClient = null;
    private static int maxHttpConnectionsPerHost = 10;
    private static int maxTotalHttpConnections = 100;

    public static void initialize() {
        SSLContext easySSLContext = new EasySSLSocketFactory().createEasySSLContext();
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(easySSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslFactory).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(maxHttpConnectionsPerHost);
        connectionManager.setMaxTotal(maxTotalHttpConnections);
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        IdleConnectionTimeoutThread idleConnectionTimeoutThread = IdleConnectionTimeoutThread.getInstance(connectionManager, 15000L);
        if (!idleConnectionTimeoutThread.isAlive()) {
            idleConnectionTimeoutThread.start();
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(0).setSocketTimeout(0).build();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionTimeToLive(30000L, TimeUnit.MILLISECONDS).setDefaultRequestConfig(requestConfig).build();
    }

    public static HttpResponse executeHttpRequest(HttpRequestBase uriRequest, String requestEncoding, CookieStore cookieStore) throws IOException, ClientProtocolException {
        if (requestEncoding != null) {
            uriRequest.getParams().setParameter("http.protocol.content-charset", (Object)requestEncoding);
        }
        BasicHttpContext context = new BasicHttpContext();
        if (cookieStore != null) {
            context.setAttribute("http.cookie-store", (Object)cookieStore);
        }
        ProxyUtil.initProxy(uriRequest, (HttpContext)context, false);
        CloseableHttpResponse httpResponse = HttpMethodUtils.getHttpClient().execute((HttpUriRequest)uriRequest, (HttpContext)context);
        return httpResponse;
    }

    public static void shutdown() {
        Closer.closeQuietly((Closeable)httpClient);
        IdleConnectionTimeoutThread timeoutThread = IdleConnectionTimeoutThread.getInstance(null, 0L);
        if (timeoutThread != null) {
            timeoutThread.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String keyStoreProvider, String keyStoreType, String keyStorePath, String keyStorePwd, String javaHome) {
        if (StringUtils.isBlank((String)keyStorePath) || StringUtils.isBlank((String)keyStoreType)) {
            return null;
        }
        char[] pwdChars = keyStorePwd != null ? keyStorePwd.toCharArray() : null;
        KeyStore ks = null;
        FileInputStream kis = null;
        try {
            ks = StringUtils.isBlank((String)keyStoreProvider) ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, keyStoreProvider);
            if (!"NONE".equals(keyStorePath)) {
                if (keyStorePath == null && javaHome != null) {
                    keyStorePath = javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
                }
                if (keyStorePath != null && new File(keyStorePath).exists()) {
                    kis = new FileInputStream(keyStorePath);
                }
            }
            ks.load(kis, pwdChars);
        }
        catch (FileNotFoundException ex) {
            LOGGER.error((Object)"FileNotFoundException occurred while getting keystore", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"IOException occurred while getting keystore", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error((Object)"NoSuchAlgorithmException occurred while getting keystore", (Throwable)ex);
        }
        catch (CertificateException ex) {
            LOGGER.error((Object)"CertificateException occurred while getting keystore", (Throwable)ex);
        }
        catch (KeyStoreException ex) {
            LOGGER.error((Object)"KeyStoreException occurred while getting keystore", (Throwable)ex);
        }
        catch (NoSuchProviderException ex) {
            LOGGER.error((Object)"NoSuchProviderException occurred while getting keystore", (Throwable)ex);
        }
        finally {
            Closer.closeQuietly(kis);
        }
        return ks;
    }

    private static KeyManager[] getKeyManagers() {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore", "");
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", "");
        String keyStorePwd = System.getProperty("javax.net.ssl.keyStorePassword", "");
        String java_home = System.getProperty("java.home");
        KeyManagerFactory kmf = null;
        try {
            KeyStore ks = HttpMethodUtils.getKeyStore(keyStoreProvider, keyStoreType, keyStorePath, keyStorePwd, java_home);
            if (ks != null) {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, keyStorePwd.toCharArray());
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"NoSuchAlgorithmException occurred while getting keystore", (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)"KeyStoreException occurred while getting keystore", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.error((Object)"UnrecoverableKeyException occurred while getting keystore", (Throwable)e);
        }
        return kmf != null ? kmf.getKeyManagers() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeHttpClient(HttpRequestBase uriRequest, String appId) {
        String resContent;
        block7: {
            resContent = "";
            try {
                HttpResponse response = HttpMethodUtils.executeHttpRequest(uriRequest, null, null);
                InputStream in = null;
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    if (response.getEntity() == null || response.getEntity().getContent() == null) break block7;
                    try {
                        in = response.getEntity().getContent();
                        resContent = IOUtils.toString((InputStream)in);
                        break block7;
                    }
                    finally {
                        Closer.closeQuietly((Closeable)in);
                    }
                }
                resContent = "{\"appId\":" + appId + ", \"ErrorMsg\": \"Server returned httpstatus code as " + response.getStatusLine().getStatusCode() + ", Please check your app environment\"}";
            }
            catch (SocketTimeoutException se) {
                resContent = StringUtils.isNotBlank((String)appId) ? "{\"appId\":" + appId + ", \"ErrorMsg\": \"Read connection timeout, please check app environment\"}" : "{\"ErrorMsg\": \"Exception occurred, please check environment\"}";
                LOGGER.error((Object)"SocketTimeoutException while executing individual appid health check ", (Throwable)se);
            }
            catch (Exception ex) {
                resContent = StringUtils.isNotBlank((String)appId) ? "{\"appId\":" + appId + ", \"ErrorMsg\": \"Error in app health check, please check app environment\"}" : "{\"ErrorMsg\": \"Exception occurred, please check environment\"}";
                LOGGER.error((Object)"Exception while executing individual appid health check ", (Throwable)ex);
            }
        }
        return resContent != null ? resContent.trim() : null;
    }

    private static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            HttpMethodUtils.initialize();
        }
        return httpClient;
    }

    private HttpMethodUtils() {
    }

    private static class EasyX509TrustManager
    implements X509TrustManager {
        private X509TrustManager standardTrustManager = null;

        EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keystore);
            TrustManager[] trustmanagers = factory.getTrustManagers();
            if (trustmanagers.length == 0) {
                throw new NoSuchAlgorithmException("no trust manager found");
            }
            this.standardTrustManager = (X509TrustManager)trustmanagers[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            this.standardTrustManager.checkClientTrusted(certificates, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            if (certificates != null && certificates.length == 1) {
                certificates[0].checkValidity();
            } else {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.standardTrustManager.getAcceptedIssuers();
        }
    }

    private static class EasySSLSocketFactory {
        private EasySSLSocketFactory() {
        }

        private SSLContext createEasySSLContext() {
            try {
                KeyStore trustKeyStore = null;
                String trustStorePath = System.getProperty("javax.net.ssl.trustStore", "");
                String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider", "");
                String trustStorePwd = System.getProperty("javax.net.ssl.trustStorePassword", "");
                String java_home = System.getProperty("java.home");
                if (trustStorePath != null && trustStorePath.trim().length() > 0) {
                    trustKeyStore = HttpMethodUtils.getKeyStore(trustStoreProvider, trustStoreType, trustStorePath, trustStorePwd, java_home);
                }
                LOGGER.debug((Object)"***** Fetching ssl algorithm from properties to get the SSLContext ******* ");
                String sslAlgorithm = (String)SSLProperties.TLS_ALGO.getFromConfig();
                LOGGER.info((Object)("configured ssl sslAlgorithm: " + sslAlgorithm));
                SSLContext context = SSLContext.getInstance(sslAlgorithm);
                context.init(HttpMethodUtils.getKeyManagers(), new TrustManager[]{new EasyX509TrustManager(trustKeyStore)}, null);
                return context;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Exception occurred", (Throwable)ex);
                return null;
            }
        }
    }

    private static class IdleConnectionTimeoutThread
    extends Thread {
        private static IdleConnectionTimeoutThread _this = null;
        private final PoolingHttpClientConnectionManager connMgr;
        private volatile boolean shutdown;
        private final long timeout;
        private final Object obj = new Object();

        private IdleConnectionTimeoutThread(PoolingHttpClientConnectionManager connMgr, long timeout) {
            super("HttpClientIdleConnectionTimeoutThread");
            this.connMgr = connMgr;
            this.timeout = timeout;
        }

        static synchronized IdleConnectionTimeoutThread getInstance(PoolingHttpClientConnectionManager connMgr, long timeout) {
            if (_this == null) {
                _this = new IdleConnectionTimeoutThread(connMgr, timeout);
            }
            return _this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    Object object = this.obj;
                    synchronized (object) {
                        this.obj.wait(this.timeout);
                    }
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            Object object = this.obj;
            synchronized (object) {
                this.obj.notifyAll();
            }
        }
    }
}

