/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.environment.impl;

import com.kony.mobilefabric.util.NetworkUtils;
import com.konylabs.middleware.cache.MemcacheProperties;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public abstract class AbstractEnvironment
implements Environment {
    private static final String KONYCENTRAL_DS = "konycentral.datasource";
    private static EnvironmentConfigBean envConfigBean;
    public static final String APP_INFO_TABLE = "app_info";
    public static final String APP_DIFF_INFO_TABLE = "server_app_diff_info";
    public static final String APP_ID = "application_id";
    public static final String APP_VERSION = "app_version";
    public static final String APP_DIFF_OBJECT = "app_diff_object";
    public static final String SERVER_APP_CONFIG = "server_app_config";
    public static final String CONFIGURATION = "configuration";
    public static final String CREATED_DATE = "created_date";
    public static final String UPDATED_DATE = "updated_date";

    public AbstractEnvironment() {
    }

    public AbstractEnvironment(EnvironmentConfigBean configBean) {
        this.setEnvConfigBean(configBean);
    }

    @Override
    public String getMemcacheCluster() {
        return (String)MemcacheProperties.CLUSTER.getFromConfig();
    }

    @Override
    public String getKonyCentralDataSource() {
        return ConfigUtility.getProperty((String)KONYCENTRAL_DS);
    }

    @Override
    public EnvironmentConfigBean getEnvConfigBean() {
        return envConfigBean;
    }

    public void setEnvConfigBean(EnvironmentConfigBean envConfigBean) {
        AbstractEnvironment.envConfigBean = envConfigBean;
    }

    @Override
    public boolean isMemCacheEnabled() {
        String memcacheCluster = this.getMemcacheCluster();
        return memcacheCluster != null && !memcacheCluster.trim().isEmpty();
    }

    @Override
    public Map<String, Object> getUpdatedConfigProps(Timestamp lastTimestamp) {
        return null;
    }

    @Override
    public int getNumberOfNodes() {
        String totalNodes = ConfigUtility.getProperty((String)"KONY_SERVER_NUMBER_OF_NODES", (String)"1");
        if (NumberUtils.isNumber((String)totalNodes)) {
            return Integer.parseInt(totalNodes);
        }
        return 1;
    }

    @Override
    public String getAccountsLoginURL(String accountsAuthUrl) {
        return accountsAuthUrl + "/" + "login";
    }

    @Override
    public String getAccountsOauthUrl(String accountsBaseUrl) {
        return accountsBaseUrl + "/oauth/";
    }

    @Override
    public String getInstanceId() {
        return NetworkUtils.getMacAddress();
    }
}

