/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.environment.impl;

import com.kony.mobilefabric.amazonaws.AWSUtils;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.connectors.logservice.SQSLogService;
import com.konylabs.middleware.environment.AuthTypeEnum;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.impl.AbstractEnvironment;
import com.konylabs.middleware.healthcheck.AppHealthCheck;
import com.konylabs.middleware.healthcheck.CloudAppHealthCheck;
import com.konylabs.middleware.registry.IRegistryManager;
import com.konylabs.middleware.registry.impl.KonyS3RegistryManager;
import com.konylabs.middleware.utilities.ConfigUtility;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public class AmazonMobileFabricEnvironment
extends AbstractEnvironment {
    private static final int CLOUD_INSTANCE_API_FREQUENCY = 30;
    private static final Logger LOGGER = Logger.getLogger(AmazonMobileFabricEnvironment.class);
    private int numberOfNodes = 1;
    private Boolean isLoadBalancerExists = null;
    private int timerCounter = 0;

    public AmazonMobileFabricEnvironment() {
    }

    public AmazonMobileFabricEnvironment(EnvironmentConfigBean configBean) {
        super(configBean);
        String region = ConfigUtility.getProperty((String)S3Config.ENV_REGION.name());
        LOGGER.info((Object)("ENV_REGION value : " + region));
        String awsEBSId = ConfigUtility.getProperty((String)S3Config.AMAZON_EBS_ID.name());
        if (StringUtils.isNotBlank((String)region)) {
            this.isLoadBalancerExists = AWSUtils.isLoadBalancerExists((String)awsEBSId);
            if (Boolean.FALSE != this.isLoadBalancerExists) {
                this.loadNumberOfNodes();
            }
        } else {
            LOGGER.error((Object)"ENV_REGION is not set in this environment");
        }
    }

    @Override
    public AuthTypeEnum getAuthType() {
        return AuthTypeEnum.OAUTH;
    }

    @Override
    public QueueService getQueueService() {
        return SQSLogService.getInstance();
    }

    @Override
    public IRegistryManager getRegistryManager() {
        return new KonyS3RegistryManager();
    }

    @Override
    public String getMemcacheCluster() {
        String memCacheCluster = ConfigUtility.getProperty((String)S3Config.MEMCACHE_CLUSTER.name());
        if (memCacheCluster != null) {
            memCacheCluster = StringUtils.replace((String)memCacheCluster, (String)"|", (String)" ").trim();
        }
        return memCacheCluster;
    }

    @Override
    public AppHealthCheck getAppHealthCheck() {
        return new CloudAppHealthCheck();
    }

    @Override
    public String getKonyCentralDataSource() {
        return ConfigUtility.getProperty((String)S3Config.KONY_DEVICEDB_DS.name());
    }

    @Override
    public String getStaticResourcesURL(String contextPath) {
        return ConfigUtility.getProperty((String)S3Config.S3_STATIC_RESOURCES_URL.name());
    }

    @Override
    public String getAccountsBaseUrl(String envUrl) {
        if (envUrl != null && !envUrl.startsWith("http") && !envUrl.startsWith("https")) {
            envUrl = "https://" + envUrl;
        }
        return envUrl;
    }

    @Override
    public String getLogoutUrl(String envUrl) {
        String baseUrl = this.getAccountsBaseUrl(envUrl);
        return baseUrl != null && baseUrl.endsWith("/") ? baseUrl + "logout" : baseUrl + "/" + "logout";
    }

    @Override
    public String doLogoutProcess(OAuthService service, Token accessToken, String endpointURL) {
        LOGGER.info((Object)("Calling URL: " + endpointURL));
        String result = null;
        try {
            OAuthRequest request = new OAuthRequest(Verb.GET, endpointURL);
            service.signRequest(accessToken, request);
            Response response = request.send();
            result = response.getBody();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to do logout", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isGatewayEnabled() {
        return true;
    }

    @Override
    public boolean isOnPremLegacyApp(String appId) {
        return false;
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void reloadNumberOfNodes() {
        if (Boolean.FALSE != this.isLoadBalancerExists) {
            ++this.timerCounter;
            if (this.timerCounter % 30 == 0) {
                if (this.isLoadBalancerExists == null) {
                    this.isLoadBalancerExists = AWSUtils.isLoadBalancerExists((String)ConfigUtility.getProperty((String)S3Config.AMAZON_EBS_ID.name()));
                }
                this.loadNumberOfNodes();
                this.timerCounter = 0;
            }
        }
    }

    private void loadNumberOfNodes() {
        Integer numberOfNodesObj = AWSUtils.getNumberOfCloudInstances((String)ConfigUtility.getProperty((String)S3Config.AMAZON_EBS_ID.name()));
        if (numberOfNodesObj != null) {
            this.numberOfNodes = numberOfNodesObj;
        }
    }

    @Override
    public String getWebAppsAPI(String accountsBaseUrl, String envGuid) {
        String accountsUrl = String.format("environments/%s/applications", envGuid);
        return accountsBaseUrl.concat(accountsUrl);
    }

    @Override
    public String getInstanceId() {
        return AWSUtils.getInstanceId();
    }
}

