/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.environment.impl;

import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.connectors.logservice.JMSLogService;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.environment.AuthTypeEnum;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.impl.AbstractEnvironment;
import com.konylabs.middleware.healthcheck.AppHealthCheck;
import com.konylabs.middleware.healthcheck.OnPremMobileFabricHealthCheck;
import com.konylabs.middleware.registry.IRegistryManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class DefaultEnvironment
extends AbstractEnvironment {
    private static final Logger LOGGER = Logger.getLogger(DefaultEnvironment.class);

    public DefaultEnvironment() {
    }

    public DefaultEnvironment(EnvironmentConfigBean configBean) {
        super(configBean);
    }

    @Override
    public boolean isGatewayEnabled() {
        return false;
    }

    @Override
    public AuthTypeEnum getAuthType() {
        return AuthTypeEnum.DEFAULT;
    }

    @Override
    public IRegistryManager getRegistryManager() {
        return (IRegistryManager)ReflectionUtils.newInstanceQuietly((String)"com.konylabs.middleware.registry.impl.KonyFileRegistryManager");
    }

    @Override
    public AppHealthCheck getAppHealthCheck() {
        return new OnPremMobileFabricHealthCheck();
    }

    @Override
    public String getStaticResourcesURL(String contextPath) {
        return contextPath + "/ui";
    }

    @Override
    public String getAccountsBaseUrl(String envUrl) {
        return null;
    }

    @Override
    public QueueService getQueueService() {
        return JMSLogService.getInstance();
    }

    @Override
    public String getAccountsOauthUrl(String accountsBaseUrl) {
        return null;
    }

    @Override
    public String getLogoutUrl(String envUrl) {
        return "/j_spring_security_logout";
    }

    @Override
    public String doLogoutProcess(OAuthService service, Token accessToken, String endpointURL) {
        HttpPost httpRequest = new HttpPost(endpointURL);
        String responseString = null;
        try {
            CloseableHttpResponse response = HttpClients.custom().build().execute((HttpUriRequest)httpRequest);
            responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to logout user session at Accounts side", (Throwable)e);
        }
        return responseString;
    }

    @Override
    public boolean isOnPremLegacyApp(String appId) {
        return false;
    }

    @Override
    public String getAccountsLoginURL(String accountsAuthUrl) {
        return null;
    }

    @Override
    public String getWebAppsAPI(String accountsBaseUrl, String envGuid) {
        return null;
    }
}

