/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.environment.impl;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.logservice.JMSLogService;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.environment.AuthTypeEnum;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.environment.impl.AbstractEnvironment;
import com.konylabs.middleware.exceptions.MiddlewareDbException;
import com.konylabs.middleware.healthcheck.AppHealthCheck;
import com.konylabs.middleware.healthcheck.OnPremMobileFabricHealthCheck;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.IRegistryManager;
import com.konylabs.middleware.registry.impl.KonyFileRegistryManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class OnPremiseMobileFabricEnvironment
extends AbstractEnvironment {
    private static final Logger LOGGER = Logger.getLogger(OnPremiseMobileFabricEnvironment.class);
    public static final String APP_ID = "application_id";
    public static final String APP_VERSION = "app_version";
    public static final String APP_CONTENT = "app_content";
    public static final String JAR_CONTENT = "jar_content";
    public static final String JAR_NAME = "jar_name";
    public static final String JAR_MODULE_NAME = "jar_module";
    public static final String APP_INFO_TABLE = "app_info";
    public static final String JAR_INFO_TABLE = "server_jar_info";
    public static final String APP_CONTENT_TYPE = "col1";
    public static final String ASSET_INFO_TABLE = "asset_info";
    public static final String ASSET_CONTENT = "asset_content";
    public static final String APP_ASSET_INFO = "app_asset_info";
    public static final String ASSET_NAME = "asset_name";
    public static final String ASSET_TYPE = "asset_type";
    public static final String USER_CONFIGURATION_TABLE = "USER_CONFIGURATION";
    private static final String APP_INFO_WITH_ID_SQL = " select * from app_info where application_id = ? ";

    public OnPremiseMobileFabricEnvironment() {
    }

    public OnPremiseMobileFabricEnvironment(EnvironmentConfigBean configBean) {
        super(configBean);
    }

    @Override
    public AuthTypeEnum getAuthType() {
        return AuthTypeEnum.OAUTH;
    }

    @Override
    public IRegistryManager getRegistryManager() {
        return new KonyFileRegistryManager();
    }

    @Override
    public AppHealthCheck getAppHealthCheck() {
        return new OnPremMobileFabricHealthCheck();
    }

    @Override
    public String getStaticResourcesURL(String contextPath) {
        return contextPath + "/ui/";
    }

    @Override
    public String getAccountsBaseUrl(String envUrl) {
        if (envUrl != null && !envUrl.startsWith("http://") && !envUrl.startsWith("https://")) {
            envUrl = "https://" + envUrl;
        }
        envUrl = envUrl + "/api/v1_0/";
        return envUrl;
    }

    @Override
    public String getLogoutUrl(String envUrl) {
        return this.getAccountsBaseUrl(envUrl) + "logout?slo=true";
    }

    @Override
    public String doLogoutProcess(OAuthService service, Token accessToken, String endpointURL) {
        HttpPost httpRequest = new HttpPost(endpointURL);
        String responseString = null;
        httpRequest.addHeader("Authorization", accessToken.getToken());
        httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            CloseableHttpResponse response = HttpClients.custom().build().execute((HttpUriRequest)httpRequest);
            int status = response.getStatusLine().getStatusCode();
            responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            LOGGER.info((Object)("Response Status : " + status));
            LOGGER.info((Object)("Response: " + responseString));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to logout user session at Accounts side", (Throwable)e);
        }
        return responseString;
    }

    @Override
    public boolean isGatewayEnabled() {
        return true;
    }

    @Override
    public QueueService getQueueService() {
        return JMSLogService.getInstance();
    }

    @Override
    public boolean isOnPremLegacyApp(String appId) {
        boolean isLegacyApp = false;
        try {
            if (this.isMobFabPublishedApp(appId)) {
                return isLegacyApp;
            }
            if (this.getRegistryManager().buildApplication(appId) != null) {
                isLegacyApp = true;
            }
        }
        catch (AppRegistryException e) {
            String errorCode = "14022";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorCode = "14022";
            String errorMessage = AppRegistryException.getErrorMessage((String)errorCode);
            LOGGER.error((Object)errorMessage, (Throwable)e);
        }
        return isLegacyApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMobFabPublishedApp(String appId) {
        PreparedStatement statement;
        ResultSet rs;
        Connection conn;
        block4: {
            boolean bl;
            LOGGER.debug((Object)"Fetching the application from Database with the given appID");
            conn = null;
            rs = null;
            statement = null;
            try {
                conn = MiddlewareDbManager.getConnection((DataSource)this.getEnvConfigBean().getDataSource());
                statement = conn.prepareStatement(APP_INFO_WITH_ID_SQL);
                statement.setString(1, appId);
                rs = statement.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (MiddlewareDbException | SQLException e) {
                try {
                    LOGGER.error((Object)"Error Fetching service definition files from Database", e);
                }
                catch (Throwable throwable) {
                    Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
                    throw throwable;
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
            }
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
            return bl;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
        return false;
    }

    @Override
    public String getWebAppsAPI(String accountsBaseUrl, String envGuid) {
        return String.format("api/v1/environments/%s/applications", envGuid);
    }
}

