/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.event.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kony.adapter.event.EventDetail;
import com.konylabs.middleware.utilities.EncodeUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpRequestEventImpl
implements EventDetail {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(HttpRequestEventImpl.class);
    private final HttpRequest httpRequest;

    public HttpRequestEventImpl(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.httpRequest.getAllHeaders() != null && this.httpRequest.getAllHeaders().length > 0) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : this.httpRequest.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            jsonObject.add("Headers", new Gson().toJsonTree(headerMap));
        }
        jsonObject.add("Method", new Gson().toJsonTree((Object)this.httpRequest.getRequestLine().getMethod()));
        jsonObject.add("Url", new Gson().toJsonTree((Object)this.httpRequest.getRequestLine().getUri()));
        HttpEntity entity = null;
        if (this.httpRequest instanceof HttpEntityEnclosingRequest) {
            entity = ((HttpEntityEnclosingRequest)this.httpRequest).getEntity();
        }
        byte[] data = null;
        if (entity == null) {
            data = new byte[]{};
        } else {
            try {
                data = EntityUtils.toByteArray((HttpEntity)entity);
            }
            catch (IOException e) {
                logger.error((Object)"error while parsing the entity.", (Throwable)e);
            }
        }
        String reqData = new String(data);
        HashMap<String, String[]> parametrMap = new HashMap<String, String[]>();
        if (reqData != null) {
            String[] pairs = reqData.split("\\&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                String name = EncodeUtils.decode((String)fields[0]);
                String value = fields.length > 1 ? EncodeUtils.decode((String)fields[1]) : "";
                String[] values = new String[1];
                if (name == null || value == null) continue;
                values[0] = value;
                parametrMap.put(name, values);
            }
        }
        parametrMap.putAll(this.getParametermap());
        jsonObject.add("Payload", new Gson().toJsonTree(parametrMap));
        return jsonObject;
    }

    private Map<String, String[]> getParametermap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String url = this.httpRequest.getRequestLine().getUri();
        int index = url.indexOf(63);
        if (index != -1) {
            String queryString = url.substring(index + 1, url.length());
            queryString = URLDecoder.decode(queryString);
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String query = st.nextToken();
                String key = query.substring(0, query.indexOf("="));
                String value = query.substring(query.indexOf("=") + 1, query.length());
                String[] values = new String[]{value};
                map.put(key, values);
            }
        }
        return map;
    }
}

