/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.event.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kony.adapter.event.EventDetail;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class HttpResponseEventImpl
implements EventDetail {
    private static final long serialVersionUID = 1L;
    private final HttpResponse httpResponse;
    private final String responseBody;

    public HttpResponseEventImpl(HttpResponse httpResponse, String responseBody) {
        this.httpResponse = httpResponse;
        this.responseBody = responseBody;
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        int statusCode = this.httpResponse.getStatusLine().getStatusCode();
        jsonObject.add("StatusCode", new Gson().toJsonTree((Object)statusCode));
        if (statusCode >= 200 && statusCode <= 299) {
            jsonObject.add("Status", new Gson().toJsonTree((Object)"Success"));
        } else {
            jsonObject.add("Status", new Gson().toJsonTree((Object)"Error"));
        }
        if (this.httpResponse.getAllHeaders() != null && this.httpResponse.getAllHeaders().length > 0) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : this.httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            jsonObject.add("Headers", new Gson().toJsonTree(headerMap));
        }
        jsonObject.add("ResponseBody", new Gson().toJsonTree((Object)this.responseBody));
        return jsonObject;
    }
}

