/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.exceptions;

import com.konylabs.middleware.exceptions.MiddlewareException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataAdapterConnectorException
extends MiddlewareException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DataAdapterConnectorException.class);
    public static String ADAPTER_TYPE_ERROR = "20001";
    public static String EMPTY_ADAPTER_TYPE = "20002";
    public static String ASYNC_WAIT_ERROR = "20003";
    public static String CREATE_OPERATOR_ERROR = "20004";
    public static String READ_OPERATOR_ERROR = "20005";
    public static String UPDATE_OPERATOR_ERROR = "20006";
    public static String DELETE_OPERATOR_ERROR = "20007";
    public static String INITIALIZE_OPERATOR_ERROR = "20008";
    public static String EMPTY_OPERAND = "20009";
    public static String DATAADAPTER_EXCEPTION = "20010";
    public static String MAPPING_EXCEPTION = "20011";
    public static String METADATA_NOT_FOUND = "20012";
    public static String SERVICE_OPERATOR_ERROR = "20013";
    public static String OBJECT_SOURCE_MAPPING_ERROR = "20014";
    public static String ERROR_MAPPER_UTILITY = "20015";
    public static String PARTIAL_UPDATE_OPERATOR_ERROR = "20016";
    public static String CREATE_BINARY_OPERATOR_ERROR = "20017";
    public static String READ_BINARY_OPERATOR_ERROR = "20018";
    public static String UPDATE_BINARY_OPERATOR_ERROR = "20019";
    public static String DELETE_BINARY_OPERATOR_ERROR = "20020";
    public static String ASSET_NOT_FOUND_ERROR = "20021";
    public static String INVALID_ODATA = "20022";

    public DataAdapterConnectorException(String errorCode, String errorMessage, int httpStatusCode) {
        super(errorCode, errorMessage, httpStatusCode);
        LOGGER.debug((Object)"DataAdapterConnector exception created with error code, HTTP status code and message.");
    }

    public DataAdapterConnectorException(String errorCode, String errorMessage) {
        super(errorCode, errorMessage);
        LOGGER.debug((Object)"DataAdapterConnector exception created with error code and message.");
    }

    public DataAdapterConnectorException(String errorCode) {
        super(errorCode, DataAdapterConnectorException.getErrorCodeMessage(errorCode));
        LOGGER.debug((Object)"DataAdapterConnector exception created with error code and message.");
    }

    public DataAdapterConnectorException(String errorCode, int httpStatusCode) {
        super(errorCode, DataAdapterConnectorException.getErrorCodeMessage(errorCode), httpStatusCode);
        LOGGER.debug((Object)"DataAdapterConnector exception created with error code, HTTP status code and message.");
    }

    public static String getErrorCodeMessage(String errorCode) {
        String errorMessage = null;
        String errorMessageKey = null;
        if (StringUtils.isNumeric((String)errorCode)) {
            int code = Integer.parseInt(errorCode);
            switch (code) {
                case 20001: {
                    errorMessageKey = "adapter_type_error";
                    break;
                }
                case 20002: {
                    errorMessageKey = "empty_adapter_type";
                    break;
                }
                case 20003: {
                    errorMessageKey = "async_wait_error";
                    break;
                }
                case 20004: {
                    errorMessageKey = "create_operator_error";
                    break;
                }
                case 20005: {
                    errorMessageKey = "read_operator_error";
                    break;
                }
                case 20006: {
                    errorMessageKey = "update_operator_error";
                    break;
                }
                case 20007: {
                    errorMessageKey = "delete_operator_error";
                    break;
                }
                case 20008: {
                    errorMessageKey = "initialization_operator_error";
                    break;
                }
                case 20009: {
                    errorMessageKey = "empty_operand";
                    break;
                }
                case 20010: {
                    break;
                }
                case 20011: {
                    errorMessageKey = "mapping_exception";
                    break;
                }
                case 20012: {
                    errorMessageKey = "mapping_exception";
                    break;
                }
                case 20014: {
                    errorMessageKey = "object_source_map_error";
                    break;
                }
                case 20015: {
                    errorMessageKey = "mapper_utility_error";
                    break;
                }
            }
        }
        errorMessage = DataAdapterConnectorException.getErrorMessageForKey(errorMessageKey);
        return errorMessage;
    }
}

