/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.exceptions;

import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.exceptions.MiddlewareException;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ObjectServicesException
extends MiddlewareException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ObjectServicesException.class);
    public static final String NO_DOWNLOD_MODE_SATISFYING_OBJECT_FOUND = "14050";
    public static final String INVALID_BATCHSIZE_IN_URL = "20022";
    public static final String SERVICE_NOT_CONFIGURED = "14051";
    public static final long CLIENT_ROW_ENTITY_ABORTON_OPSTATUS = 14052L;
    public static final long CLIENT_ROW_ENTITY_CONTINUE_ON_ERROR_CREATEFAILEED_OPSTATUS = 14053L;
    public static final long RELATED_ENTITY_CONTINUE_ON_ERROR_FAILURE_OPSTATUS = 14054L;
    public static final long BULK_UNEXPECTED_FAILURE_DURING_PROCESSING_OPSTATUS = 14056L;
    public static final String GET_RETURN_EMPTY_AFTER_SUCCESSFUL_CREATE_OR_UPDATE = "14055";
    public static final String INVALID_TIMESTAMP_FILTER = "14058";
    public static final String UNEXPECTED_EXCEPTION_OPSTATUS = "14057";
    public static final String UPLOAD_CACHE_REQUEST_REMOVED_AFTER_CACHE = "500209";
    public static final String UPLOAD_CACHE_REQUEST_IN_PROGRESS = "500210";
    public static final String UPLOAD_CACHE_BACKEND_EXCEPTION = "500211";
    public static final String UPLOAD_CACHE_EXCEPTION_WHILE_OPERATING_ON_CACHE = "500212";
    public static final String UPLOAD_CACHE_NO_REQUEST_HASH_FOUND = "500213";

    public ObjectServicesException(String errorCode, String errorMessage) {
        super(errorCode, errorMessage);
        LOGGER.debug((Object)"ObjectServices exception created with error code and message.");
    }

    public ObjectServicesException(String errorCode, String errorMessage, int httpStatusCode) {
        super(errorCode, errorMessage, httpStatusCode);
        LOGGER.debug((Object)"ObjectServices exception created with error code, message and HTTP status code.");
    }

    public ObjectServicesException(String errorCode, String errorMessage, Exception e) {
        super(errorCode, errorMessage, (Throwable)e);
        LOGGER.debug((Object)"ObjectServices exception created with error code, message and Exception.");
    }

    public static String getErrorMessageKey(String errorCode) {
        if (StringUtils.isNumeric((String)errorCode)) {
            int code = Integer.parseInt(errorCode);
            switch (code) {
                case 14050: {
                    return "no_download_mode_satisfying_object_found";
                }
                case 14051: {
                    return "service_not_configured_operation_withRowId";
                }
                case 20022: {
                    return "invalid_batchsize_in_url";
                }
                case 14052: {
                    return "client_row_entity_abortonerorr_msg";
                }
                case 14053: {
                    return "client_row_entity_continueonerror_msg";
                }
                case 14054: {
                    return "related_entity_continueonerror_msg";
                }
                case 14055: {
                    return "get_returned_empty_after_successful_create_or_update";
                }
                case 500209: {
                    return "upload_cache_request_removed_after_cache";
                }
                case 500210: {
                    return "upload_cache_request_in_progress";
                }
                case 500212: {
                    return "upload_cache_exception_while_operating_on_cache";
                }
                case 500213: {
                    return "upload_cache_no_request_has_found";
                }
            }
        }
        return "";
    }

    public static String getErrorMessage(String errorCode) {
        return MWProperties.getInstance().getErrorMessage(ObjectServicesException.getErrorMessageKey(errorCode));
    }

    public static String getErrorMessage(String errorCode, String cause) {
        return MessageFormat.format(MWProperties.getInstance().getErrorMessage(ObjectServicesException.getErrorMessageKey(errorCode)), cause);
    }
}

