/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.healthcheck;

import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseHelperFactory;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MWProperties;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.environment.HttpMethodUtils;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.healthcheck.AppHealthCheck;
import com.konylabs.middleware.healthcheck.AppHealthCheckBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AbstractAppHealthCheck
implements AppHealthCheck {
    private static final Logger LOGGER = Logger.getLogger(AbstractAppHealthCheck.class);
    protected static final String DEVICE_DB_CHK_MSG = "Access to Device DB";
    protected static final String REPORTS_DB_CHK_MSG = "Access to Reports DB";
    protected static final String ADMIN_DB_CHK_MSG = "Access to Admin DB";
    protected static final String STORAGE_DB_CHK_MSG = "Access to Storage DB";
    protected static final String QUEUE_CHK_MSG = "Access to Reporting Queue";
    private static final String HEALTHCHECK = "/healthcheck?output=json";
    private static final String CACHE_CHK_MSG = "Access to Cache";
    private static final String ERROR_INFO = "ERROR_INFO";
    private static final String ERROR_MSG = "Please check app environment";
    private static final String MSG_TYPE = "msgtype";
    private static final String MSG_TEXT = "No-Op";
    private static final String SRC = "source";
    private static final String SERVER_HC_STR = "konyserver-healthcheck";
    private static final int CACHE_TIMEOUT = 300;
    private List<AppHealthCheckBean> healthCheckBeanList = new ArrayList<AppHealthCheckBean>();

    AbstractAppHealthCheck() {
    }

    public List<AppHealthCheckBean> getHealthCheckBeanList() {
        return this.healthCheckBeanList;
    }

    public void setHealthCheckBeanList(List<AppHealthCheckBean> healthCheckBeanList) {
        this.healthCheckBeanList = healthCheckBeanList;
    }

    protected boolean isMemCacheEnabled() {
        return this.getEnvironment().isMemCacheEnabled();
    }

    protected String getAdminJNDIName() {
        return MiddlewareDbManager.getAdminJNDIName();
    }

    protected String getReportsJNDIName() {
        return MiddlewareDbManager.getReportsJNDIName();
    }

    @Override
    public List<AppHealthCheckBean> getAppHealthCheckBeanList(boolean isAdmin, boolean ignoreQueue, TenantBean<AppCache> tenantBean, CacheDirector cacheDirector) {
        this.getHealthCheckBeanList().clear();
        this.getHealthCheckStatus(isAdmin, ignoreQueue, tenantBean, cacheDirector);
        return this.getHealthCheckBeanList();
    }

    public abstract void getHealthCheckStatus(boolean var1, boolean var2, TenantBean<AppCache> var3, CacheDirector var4);

    @Override
    public List<Map<String, Object>> getAllServicesSAASHealthCheck(TenantBean<AppCache> tenantBean) {
        try {
            String envGuid = tenantBean.getEnvProperty(EnvironmentProperties.ENVIRONMENT_ID.name());
            ArrayList<Map<String, Object>> flywaySchemaColumnsList = new ArrayList<Map<String, Object>>();
            Set<AppVersion> storageServices = this.getStorageServices();
            if (storageServices != null && storageServices.size() > 0) {
                DatabaseHelper databaseHelper = DatabaseHelperFactory.createDatabaseHelper();
                StorageDatabaseDetails storageDatabaseDetails = databaseHelper.getStorageDatabaseDetails();
                for (AppVersion appVersion : storageServices) {
                    String storageSchemaName = databaseHelper.getStorageDatabaseName(appVersion.getAppId(), envGuid);
                    storageDatabaseDetails.setJdbcURL(databaseHelper.getJdbcUrlWithDatabaseName(storageSchemaName));
                    Map<String, Object> storageHealthForGivenService = StorageConnectorUtils.readLastVersionInfoFromSchemaVersion(storageDatabaseDetails, storageSchemaName);
                    if (storageHealthForGivenService == null) continue;
                    storageHealthForGivenService.put("service_name", appVersion.getAppId());
                    storageHealthForGivenService.put("schema_name", storageSchemaName);
                    flywaySchemaColumnsList.add(storageHealthForGivenService);
                }
            }
            return flywaySchemaColumnsList;
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AppVersion> getStorageServices() {
        HashSet<AppVersion> appVersions;
        Statement statement;
        ResultSet rs;
        Connection conn;
        block6: {
            LOGGER.debug((Object)"Fetching the storage services from Database");
            conn = null;
            rs = null;
            statement = null;
            appVersions = new HashSet<AppVersion>();
            try {
                if (MiddlewareDbManager.getAdminDataSource() == null) break block6;
                conn = MiddlewareDbManager.getConnection((DataSource)MiddlewareDbManager.getAdminDataSource());
                statement = conn.createStatement();
                rs = statement.executeQuery("select * from app_info where service_type = 'Storage' ");
                while (rs.next()) {
                    String appID = rs.getString("application_id");
                    String version = rs.getString("app_version");
                    if (!StringUtils.isNotBlank((String)version)) {
                        version = "1.0";
                    }
                    appVersions.add(new AppVersion(appID, version));
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)"Error while fetching service definition files from Database", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
                    throw throwable;
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
        return appVersions;
    }

    @Override
    public boolean adminHealthCheck(Map<String, String> healthcheck, List<AppHealthCheckBean> messageList) {
        LOGGER.debug((Object)"Finding the health check of the app");
        boolean healthDetail = true;
        for (AppHealthCheckBean hBean : messageList) {
            healthcheck.put(hBean.getHealthMessage(), hBean.getHealthStatus());
            if ("PASSED".equals(hBean.getHealthStatus()) || "DISABLED".equals(hBean.getHealthStatus()) || "NOT SUPPORTED".equals(hBean.getHealthStatus())) continue;
            healthDetail = false;
        }
        return healthDetail;
    }

    protected void validateCache(boolean isAdmin, TenantBean<AppCache> tenantBean, CacheDirector cacheDirector) {
        LOGGER.debug((Object)"Validating the Memcache Clusters");
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        healthCheckObj = new AppHealthCheckBean();
        healthCheckObj.setHealthMessage(CACHE_CHK_MSG);
        String errorMsg = null;
        try {
            String memCache;
            if (MiddlewareUtils.isAmazonS3Support() && StringUtils.isBlank((String)(memCache = this.getEnvironment().getMemcacheCluster()))) {
                errorMsg = "FATAL ERROR : Memcache Cluster is NULL. Please provide -D parameter as " + S3Config.MEMCACHE_CLUSTER.name();
                LOGGER.error((Object)errorMsg);
                healthCheckObj.setHealthStatus("FAILED");
                return;
            }
            if (cacheDirector == null) {
                errorMsg = "FATAL ERROR : Cache director is empty";
                LOGGER.error((Object)errorMsg);
                healthCheckObj.setHealthStatus("FAILED");
                return;
            }
            boolean success = false;
            String value = null;
            String testVal = "testing to insert/retrive and delete message";
            cacheDirector.getCache().insertIntoCache((Object)"test", (Object)testVal, 300);
            value = (String)cacheDirector.getCache().retrieveFromCache((Object)"test");
            if (StringUtils.isNotBlank((String)value) && testVal.equals(value)) {
                LOGGER.debug((Object)(value + " Successfully retrived value from memcache client."));
                boolean deleteFlag = cacheDirector.getCache().removeFromCache((Object)"test");
                if (deleteFlag) {
                    LOGGER.debug((Object)(value + " Successfully deleted value from memcache client."));
                }
                success = true;
            }
            if (success) {
                healthCheckObj.setHealthStatus("PASSED");
            } else {
                healthCheckObj.setHealthStatus("FAILED While retrieving value from cache");
                LOGGER.error((Object)"Error while validating cache connection ");
            }
        }
        catch (Exception e) {
            healthCheckObj.setHealthStatus("FAILED While inserting or retriving value from cache");
            LOGGER.error((Object)"ERROR while validating cache ", (Throwable)e);
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    protected Environment getEnvironment() {
        return EnvironmentFactory.getEnvironment();
    }

    protected String validateDSConnection(String DS, String msg) {
        LOGGER.debug((Object)("Validating the Data Source:" + DS));
        boolean valid = this.validateDBConnection(DS);
        if (valid) {
            return "PASSED";
        }
        String errorMessage = MWProperties.getInstance().getErrorMessage("health_check_failure");
        return String.format(errorMessage, "Database");
    }

    protected boolean validateDBConnection(String DS) {
        return MiddlewareDbManager.validateDBConnection((String)DS);
    }

    private String validErrorJson(String appId) {
        String str = "";
        str = StringUtils.isNotBlank((String)appId) ? "{\"appID\":\"" + appId + "\",\"" + ERROR_INFO + "\" : \"" + ERROR_MSG + "\" }" : "{\"ERROR_INFO\" : \"Please check app environment\" }";
        return str;
    }

    protected abstract Set<AppVersion> getDeployedApps(TenantBean<AppCache> var1);

    @Override
    public List<JSONObject> getAppHealthCheckJSON(boolean force, String baseURL, TenantBean<AppCache> tenantBean) throws JSONException {
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        Set<AppVersion> appList = this.getDeployedApps(tenantBean);
        LOGGER.debug((Object)("Deployed apps " + appList));
        if (appList != null && appList.size() > 0) {
            for (AppVersion appVersion : appList) {
                String appUrl = baseURL + "/" + appVersion.getAppId() + HEALTHCHECK;
                if (force) {
                    appUrl = appUrl + "&force=true";
                }
                String jsonStr = null;
                try {
                    HttpGet get = new HttpGet(appUrl);
                    jsonStr = this.executeHttpClient(appVersion, get);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Healthcheck response from appid " + appVersion + " = " + jsonStr));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)("Exception occurred while check healthcheck for " + appVersion.getAppId()));
                }
                JSONObject jsonObject = null;
                if (StringUtils.isNotBlank((String)jsonStr)) {
                    try {
                        jsonObject = new JSONObject(jsonStr);
                    }
                    catch (JSONException joex) {
                        LOGGER.warn((Object)("Exception occurred while " + appVersion + " healthcheck to json format "));
                        String str = "{\"appID\":\"" + appVersion + "\",\"errmsg\":\"Json String Syntax Error\"}";
                        jsonObject = new JSONObject(str);
                    }
                } else {
                    jsonStr = this.validErrorJson(appVersion.getAppId());
                    jsonObject = new JSONObject(jsonStr);
                }
                results.add(jsonObject);
            }
        }
        return results;
    }

    protected String executeHttpClient(AppVersion appVersion, HttpGet get) {
        return HttpMethodUtils.executeHttpClient((HttpRequestBase)get, appVersion.getAppId());
    }

    protected JSONObject testMsgForQueue() {
        JSONObject json = new JSONObject();
        try {
            json.put(MSG_TYPE, (Object)MSG_TEXT);
            json.put(SRC, (Object)SERVER_HC_STR);
            json.put("ts", (Object)CloudUtils.getDateUTCString(null));
        }
        catch (JSONException e) {
            LOGGER.error((Object)"Error in testMsgForQueue", (Throwable)e);
        }
        return json;
    }

    void validateAccessToJNDIDataSource(String DS, String msg, String dataSourceType) {
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        String jdbcDeviceDBConnectionString = DS;
        healthCheckObj = new AppHealthCheckBean();
        healthCheckObj.setHealthMessage(msg);
        try {
            if (StringUtils.isBlank((String)jdbcDeviceDBConnectionString)) {
                LOGGER.error((Object)"FATAL ERROR : JDBC DeviceDB Connection String is not specified. Please provide konycentral.datasource property in middleware.properties");
                healthCheckObj.setHealthStatus("FAILED : " + dataSourceType + " CONNECTION STRING Missed");
                this.getHealthCheckBeanList().add(healthCheckObj);
                return;
            }
            LOGGER.debug((Object)("SUCCESSFUL : JDBC " + dataSourceType + " Connection String is : " + jdbcDeviceDBConnectionString));
            String status = this.validateDSConnection(jdbcDeviceDBConnectionString, msg);
            healthCheckObj.setHealthStatus(status);
        }
        catch (Exception e) {
            healthCheckObj.setHealthStatus("FAILED While validating DB connection");
            LOGGER.error((Object)"Error while validating middleware.properties", (Throwable)e);
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void validateAccessToStorageDataSource(String storageDbChkMsg, String description) {
        AppHealthCheckBean healthCheckObj;
        block11: {
            healthCheckObj = new AppHealthCheckBean();
            healthCheckObj.setHealthMessage(storageDbChkMsg);
            DatabaseHelper databaseHelper = null;
            Connection conn = null;
            try {
                StorageDatabaseDetails storageDatabaseDetails = DatabaseHelperFactory.populateStorageDatabaseDetails();
                if (StorageConnectorUtils.StorageDatabaseType.db2.toString().equalsIgnoreCase(storageDatabaseDetails.getDatabaseType())) {
                    LOGGER.info((Object)"DB2 is not supported for storage services");
                    healthCheckObj.setHealthStatus("NOT SUPPORTED");
                } else {
                    databaseHelper = DatabaseHelperFactory.createDatabaseHelper(storageDatabaseDetails);
                    conn = databaseHelper.getDatabaseConnection();
                    if (conn != null) {
                        LOGGER.info((Object)"SUCCESSFUL : Access to Storage Database is validated ");
                        healthCheckObj.setHealthStatus("PASSED");
                    } else {
                        LOGGER.error((Object)"FAILED : Unable to access Storage Database");
                        healthCheckObj.setHealthStatus("FAILED");
                    }
                }
                Closer.closeQuietly((AutoCloseable)conn);
            }
            catch (SQLException e) {
                LOGGER.error((Object)("Error while access Storage Database, Missing Storage Details: " + databaseHelper.getMissingFields()), (Throwable)e);
                healthCheckObj.setHealthStatus("FAILED");
                Closer.closeQuietly((AutoCloseable)conn);
            }
            catch (IllegalArgumentException e2) {
                LOGGER.error((Object)e2, (Throwable)e2);
                healthCheckObj.setHealthStatus("FAILED");
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closer.closeQuietly(conn);
            }
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }
}

