/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.healthcheck;

import com.kony.mobilefabric.amazonaws.AWSUtils;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.kony.mobilefabric.cloudqueue.impl.AWSCloudQueue;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.environment.HttpMethodUtils;
import com.konylabs.middleware.healthcheck.AbstractAppHealthCheck;
import com.konylabs.middleware.healthcheck.AppHealthCheckBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;

public class CloudAppHealthCheck
extends AbstractAppHealthCheck {
    private static final Logger LOGGER = Logger.getLogger(CloudAppHealthCheck.class);
    private static final String ENV_CHK_MSG = "Cloud Environment Identification";
    private static final String S3_CHK_MSG = "Access to Deployment Storage";
    private static final String AWS_ACCESS_CHK_MSG = "Security Credentials";
    private static final String INTERNAL = "/api/v1_0/internal/environments/";
    private static final String APPS_STATUS = "/app-ids?status=deployed";

    @Override
    public void getHealthCheckStatus(boolean isAdmin, boolean ignoreQueue, TenantBean<AppCache> tenantBean, CacheDirector cacheDirector) {
        this.validatecloudsupportParam();
        if (!ignoreQueue) {
            this.validateSQSQueueUrl();
        }
        if (!TenantUtilities.isMultiTenant()) {
            this.validateKonyDeviceDSCredentials(tenantBean);
            this.validateAmazonS3UrlConfig(tenantBean);
        }
        this.validateAmazonEnvironmentCredentialsParam();
        this.validateAccessToJNDIDataSource(this.getAdminJNDIName(), "Access to Admin DB", "Admin Data Source");
        this.validateCache(isAdmin, tenantBean, cacheDirector);
        this.validateAccessToStorageDataSource("Access to Storage DB", "Storage Data Source");
    }

    void validatecloudsupportParam() {
        LOGGER.debug((Object)"Validating the cloud related settings");
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        healthCheckObj.setHealthMessage(ENV_CHK_MSG);
        try {
            if (!this.isAmazonS3Support()) {
                LOGGER.error((Object)"FATAL ERROR : CloudMode is NULL/Empty. Please provide CLOUD_MODE=TRUE as -D parameter.");
                healthCheckObj.setHealthStatus("FAILED");
            } else {
                LOGGER.debug((Object)"SUCCESSFUL : CLOUD_MODE is set to : true");
                healthCheckObj.setHealthStatus("PASSED");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while checking CLOUD_MODE jvm argument ", (Throwable)e);
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    protected boolean isAmazonS3Support() {
        return MiddlewareUtils.isAmazonS3Support();
    }

    void validateAmazonS3UrlConfig(TenantBean<AppCache> tenantBean) {
        LOGGER.debug((Object)"Validating the Amazon S3 settings");
        String s3BucketName = tenantBean.getEnvProperty(S3Config.SERVERAPPS_AMAZON_S3_CONFIG.name());
        LOGGER.debug((Object)("Amazon S3 bucket name : " + s3BucketName));
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        healthCheckObj.setHealthMessage(S3_CHK_MSG);
        if (StringUtils.isBlank((String)s3BucketName)) {
            LOGGER.error((Object)("FATAL ERROR : Amazon S3 url is not specified. Please provide -D parameter as " + S3Config.SERVERAPPS_AMAZON_S3_CONFIG.name()));
            healthCheckObj.setHealthStatus("FAILED");
        } else {
            try {
                if (this.isS3BucketExist(tenantBean, s3BucketName)) {
                    healthCheckObj.setHealthStatus("PASSED");
                } else {
                    LOGGER.error((Object)"The S3 bucket does not exist ");
                    healthCheckObj.setHealthStatus("FAILED");
                }
            }
            catch (Exception e) {
                healthCheckObj.setHealthStatus("FAILED");
                LOGGER.error((Object)"Error while checking S3 buckek health check ", (Throwable)e);
            }
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    protected boolean isS3BucketExist(TenantBean<AppCache> tenantBean, String bucketName) throws Exception {
        return CloudUtils.doesBucketExist(bucketName, tenantBean);
    }

    void validateSQSQueueUrl() {
        LOGGER.debug((Object)"Validating the SQS related settings");
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        try {
            healthCheckObj.setHealthMessage("Access to Reporting Queue");
            String sqsQueueUrl = ConfigUtility.getProperty((String)S3Config.SQS_QUEUE_URL.name());
            LOGGER.debug((Object)("SQS queue URL : " + sqsQueueUrl));
            if (StringUtils.isNotBlank((String)sqsQueueUrl)) {
                AWSCloudQueue cloudQueue = this.getCloudQueue(sqsQueueUrl.trim());
                String testMsgForHealthcheck = this.testMsgForQueue().toString();
                LOGGER.debug((Object)("Test message pushing to SQS for healthcheck : " + testMsgForHealthcheck));
                String messageId = cloudQueue.sendMessage(testMsgForHealthcheck);
                if (StringUtils.isNotBlank((String)messageId)) {
                    healthCheckObj.setHealthStatus("PASSED");
                } else {
                    healthCheckObj.setHealthStatus("FAILED");
                }
            } else {
                LOGGER.error((Object)"SQS_QUEUE_URL is not found in the environment configuration ");
                healthCheckObj.setHealthStatus("FAILED : SQS_QUEUE_URL is not configured.");
            }
            LOGGER.debug((Object)"SUCCESSFUL : Access to Reporting Queue and SQS is validated ");
        }
        catch (Exception ex) {
            LOGGER.error((Object)"ERROR:: while queue url look up", (Throwable)ex);
            healthCheckObj.setHealthStatus("FAILED : Connection failed.");
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    void validateAmazonEnvironmentCredentialsParam() {
        LOGGER.debug((Object)"Validating the Environment related settings");
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        healthCheckObj.setHealthMessage(AWS_ACCESS_CHK_MSG);
        healthCheckObj.setHealthStatus("PASSED");
        if (this.isEmptyAccessKeyAndSecretKey() && StringUtils.isBlank((String)this.getAwsSessionToken())) {
            healthCheckObj.setHealthMessage("Security Credentials (Role)");
            healthCheckObj.setHealthStatus("FAILED");
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    protected AWSCloudQueue getCloudQueue(String sqsQueueUrl) {
        return new AWSCloudQueue(sqsQueueUrl);
    }

    protected String getAwsSessionToken() {
        return AWSUtils.getAwsSessionToken();
    }

    protected boolean isEmptyAccessKeyAndSecretKey() {
        return StringUtils.isNotBlank((String)AWSUtils.getAwsAccessKeyId()) && StringUtils.isNotBlank((String)AWSUtils.getAwsSecretKey());
    }

    protected void validateKonyDeviceDSCredentials(TenantBean<AppCache> tenantBean) {
        LOGGER.debug((Object)"Validating the Device DB settings");
        AppHealthCheckBean healthCheckObj = new AppHealthCheckBean();
        String jdbcDeviceDBConnectionString = tenantBean.getEnvProperty(S3Config.KONY_DEVICEDB_DS.name());
        healthCheckObj.setHealthMessage("Access to Device DB");
        try {
            if (StringUtils.isBlank((String)jdbcDeviceDBConnectionString)) {
                LOGGER.error((Object)("FATAL ERROR : JDBC DeviceDB Connection String is not specified. Please provide -D parameter as " + S3Config.KONY_DEVICEDB_DS.name()));
                healthCheckObj.setHealthStatus("FAILED : DEVICEDB CONNECTION STRING Missed");
                this.getHealthCheckBeanList().add(healthCheckObj);
                return;
            }
            LOGGER.debug((Object)("SUCCESSFUL : JDBC DeviceDB Connection String is : " + jdbcDeviceDBConnectionString));
            String rdsPassword = tenantBean.getEnvProperty(S3Config.JDBC_DEVICEDB_PASSWORD.name());
            String rdsUserName = tenantBean.getEnvProperty(S3Config.JDBC_DEVICEDB_USER.name());
            if (StringUtils.isBlank((String)rdsUserName)) {
                LOGGER.error((Object)("FATAL ERROR : Amazon RDS Username is NULL. Please provide -D parameter as " + S3Config.JDBC_DEVICEDB_USER.name()));
                healthCheckObj.setHealthStatus("FAILED : DEVICEDB USERNAME Missed");
                this.getHealthCheckBeanList().add(healthCheckObj);
                return;
            }
            if (StringUtils.isBlank((String)rdsPassword)) {
                LOGGER.error((Object)("FATAL ERROR : Amazon RDS Password is NULL. Please provide -D parameter as " + S3Config.JDBC_DEVICEDB_PASSWORD.name()));
                healthCheckObj.setHealthStatus("FAILED : DEVICEDB PASSWORD Missed");
                this.getHealthCheckBeanList().add(healthCheckObj);
                return;
            }
            String status = this.validateDSConnection(jdbcDeviceDBConnectionString, "Access to Device DB");
            healthCheckObj.setHealthStatus(status);
        }
        catch (Exception e) {
            healthCheckObj.setHealthStatus("FAILED While validating DB connection");
            LOGGER.error((Object)"Error while validating device DB jvm arguments ", (Throwable)e);
        }
        this.getHealthCheckBeanList().add(healthCheckObj);
    }

    @Override
    public Set<AppVersion> getDeployedApps(TenantBean<AppCache> tenantBean) {
        String appStatusURL;
        HttpGet get;
        String deployedApps;
        String envId;
        LOGGER.debug((Object)"Finding the deployed apps in cloud");
        HashSet<AppVersion> appIdSet = new HashSet<AppVersion>();
        String accountUIurl = tenantBean != null ? tenantBean.getEnvProperty(EnvironmentProperties.KONY_ACCOUNT_UI_BASE_URL.name()) : null;
        String string = envId = tenantBean != null ? tenantBean.getEnvProperty(EnvironmentProperties.ENVIRONMENT_ID.name()) : null;
        if (StringUtils.isNotBlank((String)accountUIurl) && !accountUIurl.startsWith("http") && !accountUIurl.startsWith("https")) {
            accountUIurl = "https://" + accountUIurl;
        }
        if (StringUtils.isNotBlank((String)(deployedApps = this.executeHttpClient(get = new HttpGet(appStatusURL = accountUIurl + INTERNAL + envId + APPS_STATUS))))) {
            try {
                JSONArray jsonArray = new JSONArray(deployedApps);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String appId = jsonArray.getString(i);
                    appIdSet.add(new AppVersion(appId, null));
                }
            }
            catch (JSONException e) {
                LOGGER.error((Object)"Exception while fetching the Deployed Apps from Accounts", (Throwable)e);
            }
        }
        return appIdSet;
    }

    protected String executeHttpClient(HttpGet get) {
        return HttpMethodUtils.executeHttpClient((HttpRequestBase)get, null);
    }
}

