/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.healthcheck;

import com.google.gson.Gson;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.healthcheck.AppHealthCheck;
import com.konylabs.middleware.healthcheck.AppHealthCheckBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HealthCheckUtils {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckUtils.class);

    public String getHealthCheck(TenantBean<AppCache> tenantBean, CacheDirector cacheDirector) {
        Gson gson = new Gson();
        boolean isAdmin = !MiddlewareUtils.isServicesWar();
        List<AppHealthCheckBean> appHealthCheckBeanList = this.getAppHealthCheckBeanList(tenantBean, isAdmin, false, cacheDirector);
        HashMap<String, String> healthcheckMap = new HashMap<String, String>();
        this.buildAndGetOverAllHealthCheckStatus(healthcheckMap, appHealthCheckBeanList);
        return gson.toJson(healthcheckMap);
    }

    public List<AppHealthCheckBean> getAppHealthCheckBeanList(TenantBean<AppCache> tenantBean, boolean isAdmin, boolean ignoreQueueFlag, CacheDirector cacheDirector) {
        AppHealthCheck healthCheck = EnvironmentFactory.getEnvironment().getAppHealthCheck();
        List<AppHealthCheckBean> messageList = healthCheck.getAppHealthCheckBeanList(isAdmin, ignoreQueueFlag, tenantBean, cacheDirector);
        if (LOGGER.isDebugEnabled()) {
            for (AppHealthCheckBean bean : messageList) {
                LOGGER.debug((Object)("Message " + bean.getHealthMessage() + " = " + bean.getHealthStatus()));
            }
        }
        return messageList;
    }

    public boolean buildAndGetOverAllHealthCheckStatus(Map<String, String> healthcheckMap, List<AppHealthCheckBean> appHealthCheckBeanList) {
        AppHealthCheck healthCheck = EnvironmentFactory.getEnvironment().getAppHealthCheck();
        return healthCheck.adminHealthCheck(healthcheckMap, appHealthCheckBeanList);
    }
}

