/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.healthcheck;

import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.exceptions.MiddlewareDbException;
import com.konylabs.middleware.healthcheck.AbstractAppHealthCheck;
import com.konylabs.middleware.healthcheck.AppHealthCheckBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OnPremMobileFabricHealthCheck
extends AbstractAppHealthCheck {
    private static final Logger LOGGER = Logger.getLogger(OnPremMobileFabricHealthCheck.class);
    private AppHealthCheckBean healthCheckObj = null;

    @Override
    public void getHealthCheckStatus(boolean isAdmin, boolean ignoreQueue, TenantBean<AppCache> tenantBean, CacheDirector cacheDirector) {
        if (isAdmin) {
            this.validateAccessToJNDIDataSource(this.getReportsJNDIName(), "Access to Reports DB", "Reports Data Source");
        }
        this.validateAccessToJNDIDataSource(this.getAdminJNDIName(), "Access to Admin DB", "Admin Data Source");
        if (CacheUtils.isSesionDistributed().booleanValue()) {
            LOGGER.debug((Object)"Session is distributed");
            this.validateCache(isAdmin, tenantBean, cacheDirector);
        }
        if (!ignoreQueue) {
            this.validateTopic(isAdmin);
        }
        this.validateAccessToStorageDataSource("Access to Storage DB", "Storage Data Source");
    }

    void validateTopic(boolean isAdmin) {
        block5: {
            this.healthCheckObj = new AppHealthCheckBean();
            this.healthCheckObj.setHealthMessage("Access to Reporting Queue");
            String metricsLogging = this.getPropertyFromConfig("metrics.logging");
            if (metricsLogging != null && metricsLogging.equalsIgnoreCase("true")) {
                try {
                    QueueService queueService = this.getEnvironment().getQueueService();
                    if (queueService.pushMessage(this.testMsgForQueue())) {
                        LOGGER.info((Object)"SUCCESSFUL : Access to Reporting Topic is validated ");
                        this.healthCheckObj.setHealthStatus("PASSED");
                        break block5;
                    }
                    LOGGER.info((Object)"ERROR : Unable to Validate the Reporting Topic ");
                    this.healthCheckObj.setHealthStatus("FAILED");
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"ERROR:: while queue url look up", (Throwable)ex);
                }
            } else {
                this.healthCheckObj.setHealthStatus("DISABLED");
            }
        }
        this.getHealthCheckBeanList().add(this.healthCheckObj);
    }

    protected String getPropertyFromConfig(String key) {
        return ConfigUtility.getProperty((String)key, (String)"true");
    }

    @Override
    protected Environment getEnvironment() {
        return EnvironmentFactory.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AppVersion> getDeployedApps(TenantBean<AppCache> tenantBean) {
        HashSet<AppVersion> appVersions;
        Statement statement;
        ResultSet rs;
        Connection conn;
        block6: {
            LOGGER.debug((Object)"Fetching the studio apps files from Database");
            conn = null;
            rs = null;
            statement = null;
            appVersions = new HashSet<AppVersion>();
            try {
                if (MiddlewareDbManager.getAdminDataSource() == null) break block6;
                conn = MiddlewareDbManager.getConnection((DataSource)MiddlewareDbManager.getAdminDataSource());
                statement = conn.createStatement();
                rs = statement.executeQuery("select * from app_info where service_category = 'StudioService' ");
                while (rs.next()) {
                    String appID = rs.getString("application_id");
                    String version = rs.getString("app_version");
                    if (!StringUtils.isNotBlank((String)version)) {
                        version = "1.0";
                    }
                    appVersions.add(new AppVersion(appID, version));
                }
            }
            catch (MiddlewareDbException | SQLException e) {
                try {
                    LOGGER.error((Object)"Error Fetching service definition files from Database", e);
                }
                catch (Throwable throwable) {
                    Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
                    throw throwable;
                }
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, statement, conn});
        return appVersions;
    }
}

