/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.identityproviders;

import com.jayway.jsonpath.DocumentContext;
import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.connectors.json.JsonPath;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class MBaaSIdentityProviderUtil {
    public static final String IDENTITY_ATTRIBUTE_TYPE_PROFILE = "profile";
    public static final String IDENTITY_ATTRIBUTE_TYPE_SECURITY = "security";
    private static final Logger logger = Logger.getLogger(MBaaSIdentityProviderUtil.class);

    public static Object fetchIdentityToken(String paramValue, Gateway gateway) throws GatewayException {
        logger.debug((Object)("Fetching the Identity Tokens, Token Expression : " + paramValue));
        if (paramValue != null && gateway != null) {
            String[] tokens = paramValue.split("\\.");
            if (tokens.length >= 3) {
                Map identityTokens = null;
                String identityProviderName = tokens[0];
                String identityAttributeType = tokens[1];
                String attributeName = paramValue.substring(identityProviderName.length() + identityAttributeType.length() + 2);
                logger.debug((Object)("Identity provider name : " + identityProviderName + ", attribute type  :" + identityAttributeType + ", attribute name : " + attributeName));
                if (IDENTITY_ATTRIBUTE_TYPE_SECURITY.equalsIgnoreCase(identityAttributeType)) {
                    identityTokens = gateway.getSecurityAttributes(identityProviderName, false);
                } else if (IDENTITY_ATTRIBUTE_TYPE_PROFILE.equalsIgnoreCase(identityAttributeType)) {
                    identityTokens = gateway.getUserAttributes(identityProviderName);
                } else {
                    logger.error((Object)("Invalid Identity attribute type found : " + identityAttributeType));
                }
                if (identityTokens != null) {
                    logger.debug((Object)("Identitytokens size " + identityTokens.size()));
                    return MBaaSIdentityProviderUtil.getIdentityAttributeValue(identityTokens, attributeName);
                }
                logger.error((Object)"Failed to retrieve the Identity Tokens for the specified identity provider");
            } else {
                logger.error((Object)("Invalid identity scope parameter format found : " + paramValue));
            }
        }
        return null;
    }

    public static Object getIdentityAttributeValue(Map<String, Object> identityTokens, String tokenPath) {
        if (identityTokens.containsKey(tokenPath)) {
            return identityTokens.get(tokenPath);
        }
        String rawResponse = (String)identityTokens.get("raw_response");
        String attributeValue = MBaaSIdentityProviderUtil.extractAttributeFromJSON(rawResponse, tokenPath);
        if (StringUtils.isNotBlank((String)attributeValue)) {
            identityTokens.put(tokenPath, attributeValue);
        }
        return attributeValue;
    }

    public static String extractAttributeFromJSON(String rawResponse, String tokenPath) {
        if (StringUtils.isNotBlank((String)rawResponse)) {
            return (String)JsonPath.read((DocumentContext)com.jayway.jsonpath.JsonPath.parse((String)rawResponse), (String)tokenPath);
        }
        return null;
    }

    private MBaaSIdentityProviderUtil() {
    }
}

