/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.identityproviders.impl;

import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.MBaaSException;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.registry.vo.Header;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MaskUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractMBaaSIdentityProvider
implements MBaaSIdentityProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractMBaaSIdentityProvider.class);
    private Service service;
    private String providerURL;
    private String providerType;
    private DataControllerRequest dataControllerRequest;
    private Map<String, Object> requestHeaderMap = new HashMap<String, Object>();
    protected static final String AUTHORIZATION_REQUEST_HEADER_VALUE_PREFIX = "Bearer ";
    public static final String ACCESS_TOKEN_NAME = "access_token";
    public static final String INSTANCE_URL = "instance_url";
    protected static final String AUTH_REQUEST_HEADER_NAME = "Authorization";

    public AbstractMBaaSIdentityProvider() {
    }

    public AbstractMBaaSIdentityProvider(Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) {
        this.service = service;
        this.requestHeaderMap = requestHeaderMap;
        this.providerURL = this.getIdentityProviderURL(service);
        this.providerType = this.getIdentityProviderType(service);
        this.dataControllerRequest = dataControllerRequest;
    }

    @Override
    public String getIdentityProviderType(Service service) {
        return service.getServiceConfig().getConfigParamValue("identityProviderType");
    }

    @Override
    public String getIdentityProviderURL(Service service) {
        return service.getServiceConfig().getConfigParamValue("identityProvider");
    }

    @Override
    public Map<String, Object> getBackendTokens(Gateway gateway) throws MBaaSException {
        LOGGER.debug((Object)"Getting the Auth Token Values Map");
        HashMap<String, Object> tokenValues = new HashMap();
        if (gateway != null) {
            try {
                tokenValues = gateway.getSecurityAttributes(this.providerURL, false);
            }
            catch (GatewayException e) {
                String errorCode = "17009";
                String errorMessage = MBaaSException.getErrorCodeMessage((String)errorCode);
                errorMessage = MessageFormat.format(errorMessage, e.getError().getMfCode());
                MaskUtils.maskTrace((String)errorMessage, (Throwable)e);
                throw new MBaaSException(errorCode, errorMessage, 401, (Exception)((Object)e));
            }
            catch (Exception e) {
                String errorCode = "17002";
                String errorMessage = MBaaSException.getErrorCodeMessage((String)errorCode);
                errorMessage = MessageFormat.format(errorMessage, this.providerURL);
                MaskUtils.maskTrace((String)errorMessage, (Throwable)e);
                throw new MBaaSException(errorCode, errorMessage, 401, e);
            }
        } else {
            LOGGER.error((Object)"Gateway is not instantiated due to invalid or no authorization token found in request");
            throw new MBaaSException("17010", MBaaSException.getErrorMessageForKey((String)"missing_x_kony_auth_token_for_idenity_params"));
        }
        return tokenValues;
    }

    @Override
    public Service addServiceHeaders(Service service, String key, String value, String scope) {
        LOGGER.debug((Object)"Adding the Headers in the Service Input");
        Param newParam = new Param();
        newParam.setValue(value);
        newParam.setName(key);
        if (StringUtils.isNotBlank((String)scope)) {
            newParam.setSource(scope);
        }
        Header headerParam = null;
        if (!service.getServiceInput().getHeaders().isEmpty()) {
            headerParam = (Header)service.getServiceInput().getHeaders().get(0);
            ArrayList paramsList = headerParam.getParam();
            if (paramsList != null) {
                for (Param param : paramsList) {
                    if (!key.equalsIgnoreCase(param.getName())) continue;
                    paramsList.remove(param);
                    break;
                }
            }
        } else {
            headerParam = new Header();
            service.getServiceInput().getHeaders().add(headerParam);
        }
        headerParam.getParam().add(newParam);
        return service;
    }

    @Override
    public Service addServiceInput(String key, String value) {
        LOGGER.debug((Object)"Adding the params in the Service Input");
        return this.service;
    }

    public Service getService() {
        return this.service;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public Map<String, Object> getRequestHeaderMap() {
        return this.requestHeaderMap;
    }

    public void setRequestHeaderMap(Map<String, Object> requestHeaderMap) {
        this.requestHeaderMap = requestHeaderMap;
    }

    public DataControllerRequest getDataControllerRequest() {
        return this.dataControllerRequest;
    }

    protected boolean isRestConnectorType() {
        return MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.jsonConnector.name().equalsIgnoreCase(this.getService().getServiceType()) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.plainxmlserviceConnector.name().equalsIgnoreCase(this.getService().getServiceType()) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.dataAdapterConnector.name().equalsIgnoreCase(this.getService().getServiceType()) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.APIProxyConnector.name().equalsIgnoreCase(this.getService().getServiceType()) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.inProcConnector.name().equalsIgnoreCase(this.getService().getServiceType());
    }
}

