/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.identityproviders.impl;

import com.kony.api.gateway.Gateway;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.MBaaSException;
import com.konylabs.middleware.identityproviders.impl.AbstractMBaaSIdentityProvider;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OAuth2IdentityProvider
extends AbstractMBaaSIdentityProvider {
    private static final Logger LOGGER = Logger.getLogger(OAuth2IdentityProvider.class);

    public OAuth2IdentityProvider() {
    }

    public OAuth2IdentityProvider(Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) {
        super(service, requestHeaderMap, dataControllerRequest);
    }

    @Override
    public Service popoulateIdentityProviderChanges(Gateway gateway) throws MBaaSException {
        Service service = this.getService();
        Map<String, Object> sfdcValuesMap = this.getRequestHeaderMap();
        String accessTokenValue = null;
        if (this.isRestConnectorType()) {
            LOGGER.debug((Object)"Populating the changes for SFDC Rest Connector");
            if (sfdcValuesMap != null && sfdcValuesMap.containsKey("x-kony-server-console")) {
                LOGGER.debug((Object)"Access Token and Instance URL are fetched from Server Console");
                sfdcValuesMap = MiddlewareUtils.convertToLowerCaseMap(sfdcValuesMap);
                accessTokenValue = (String)sfdcValuesMap.get("x-kony-oauth2-access-token");
            }
            if (StringUtils.isBlank(accessTokenValue)) {
                LOGGER.debug((Object)"Access Token and Instance URL are fetched from MBaaS Backend Tokens");
                sfdcValuesMap = this.getBackendTokens(gateway);
                accessTokenValue = (String)sfdcValuesMap.get("access_token");
            }
            if (StringUtils.isBlank(accessTokenValue)) {
                String errorCode = "17004";
                String errorMessage = MBaaSException.getErrorCodeMessage((String)errorCode);
                LOGGER.error((Object)errorMessage);
                throw new MBaaSException(errorCode, errorMessage, 401);
            }
            service = this.populateRestServiceHeaders(service, accessTokenValue);
        } else {
            LOGGER.info((Object)("Backend tokens are not supported for this service type : " + this.getService().getServiceType()));
        }
        return service;
    }

    private Service populateRestServiceHeaders(Service service, String authTokenValue) {
        LOGGER.debug((Object)"Populating the SFDC Rest Header values");
        if (this.getDataControllerRequest() != null) {
            HashMap<String, String> headersMap = new HashMap<String, String>();
            headersMap.put("Authorization", "Bearer " + authTokenValue);
            this.getDataControllerRequest().setAttribute("IDENTITY_HEADERS", headersMap);
        } else {
            this.addServiceHeaders(service, "Authorization", "Bearer " + authTokenValue, "request");
        }
        return service;
    }
}

