/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.identityproviders.impl;

import com.kony.api.gateway.Gateway;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.MBaaSException;
import com.konylabs.middleware.identityproviders.impl.AbstractMBaaSIdentityProvider;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SKYRestMBaaSIdentityProvider
extends AbstractMBaaSIdentityProvider {
    private static final Logger LOGGER = Logger.getLogger(SKYRestMBaaSIdentityProvider.class);

    public SKYRestMBaaSIdentityProvider() {
    }

    public SKYRestMBaaSIdentityProvider(Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) {
        super(service, requestHeaderMap, dataControllerRequest);
    }

    @Override
    public Service popoulateIdentityProviderChanges(Gateway gateway) throws MBaaSException {
        Service service = this.getService();
        Map<String, Object> inputHeaderValueMap = this.getRequestHeaderMap();
        if (this.isRestConnectorType()) {
            String sapSessionKey = null;
            LOGGER.debug((Object)"Populating the changes for SKY Rest Connector");
            if (inputHeaderValueMap != null && inputHeaderValueMap.containsKey("x-kony-server-console")) {
                LOGGER.debug((Object)"Required Headers are fetched from Server Console");
                inputHeaderValueMap = MiddlewareUtils.convertToLowerCaseMap(inputHeaderValueMap);
                sapSessionKey = (String)inputHeaderValueMap.get("konysap-session-key");
            }
            if (StringUtils.isBlank(sapSessionKey)) {
                inputHeaderValueMap = this.getBackendTokens(gateway);
                LOGGER.debug((Object)"Required Headers are fetched from MBaaS Backend Tokens");
            }
            service = this.populateRestServiceHeaders(inputHeaderValueMap);
        } else {
            LOGGER.info((Object)("Backend tokens are not supported for this service type : " + this.getService().getServiceType()));
        }
        return service;
    }

    private Service populateRestServiceHeaders(Map<String, Object> headerValueMap) {
        Service service = this.getService();
        LOGGER.debug((Object)"Populating the SKY Rest Header values");
        if (headerValueMap != null) {
            HashMap<String, String> headersMap = new HashMap<String, String>();
            for (String headerName : headerValueMap.keySet()) {
                if (MWConstants.REQUEST_HEADERS_EXCLUDE_LIST.contains(headerName) || headerName.equalsIgnoreCase("user-agent") || headerName.equalsIgnoreCase("content-type")) continue;
                if (this.getDataControllerRequest() != null) {
                    headersMap.put(headerName, (String)headerValueMap.get(headerName));
                    continue;
                }
                this.addServiceHeaders(service, headerName, (String)headerValueMap.get(headerName), "request");
            }
            if (this.getDataControllerRequest() != null) {
                this.getDataControllerRequest().setAttribute("IDENTITY_HEADERS", headersMap);
            }
        }
        return service;
    }
}

