/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.identityproviders.impl;

import com.kony.api.gateway.Gateway;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.MBaaSException;
import com.konylabs.middleware.identityproviders.impl.AbstractMBaaSIdentityProvider;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SalesForceMBaaSIdentityProvider
extends AbstractMBaaSIdentityProvider {
    private static final Logger LOGGER = Logger.getLogger(SalesForceMBaaSIdentityProvider.class);

    public SalesForceMBaaSIdentityProvider() {
    }

    public SalesForceMBaaSIdentityProvider(Service service, Map<String, Object> requestHeaderMap, DataControllerRequest dataControllerRequest) {
        super(service, requestHeaderMap, dataControllerRequest);
    }

    @Override
    public Service popoulateIdentityProviderChanges(Gateway gateway) throws MBaaSException {
        Service service = this.getService();
        Map<String, Object> sfdcValuesMap = this.getRequestHeaderMap();
        String instanceUrl = null;
        String accessTokenValue = null;
        if (this.isRestConnectorType()) {
            LOGGER.debug((Object)"Populating the changes for SFDC Rest Connector");
            if (sfdcValuesMap != null && sfdcValuesMap.containsKey("x-kony-server-console")) {
                LOGGER.debug((Object)"Fetching Access Token and Instance URL from Server Console headers");
                sfdcValuesMap = MiddlewareUtils.convertToLowerCaseMap(sfdcValuesMap);
                accessTokenValue = (String)sfdcValuesMap.get("x-kony-sfdc-access-token");
                instanceUrl = (String)sfdcValuesMap.get("x-kony-sfdc-instance-url");
            }
            if (StringUtils.isBlank(accessTokenValue) && StringUtils.isBlank(instanceUrl)) {
                LOGGER.debug((Object)"Fetching Access Token and Instance URL from Backend Tokens in Claims");
                sfdcValuesMap = this.getBackendTokens(gateway);
                instanceUrl = (String)sfdcValuesMap.get("instance_url");
                accessTokenValue = (String)sfdcValuesMap.get("access_token");
            }
            if (StringUtils.isBlank(accessTokenValue) && StringUtils.isBlank(instanceUrl)) {
                String errorCode = "17008";
                String errorMessage = MBaaSException.getErrorCodeMessage((String)errorCode);
                LOGGER.error((Object)errorMessage);
                throw new MBaaSException(errorCode, errorMessage, 401);
            }
            if (StringUtils.isBlank(accessTokenValue)) {
                String errorCode = "17004";
                String errorMessage = MBaaSException.getErrorCodeMessage((String)errorCode);
                LOGGER.error((Object)errorMessage);
                throw new MBaaSException(errorCode, errorMessage, 401);
            }
            if (StringUtils.isBlank(instanceUrl)) {
                String errorCode = "17003";
                String errorMessage = MBaaSException.getErrorCodeMessage((String)errorCode);
                LOGGER.error((Object)errorMessage);
                throw new MBaaSException(errorCode, errorMessage, 401);
            }
            service = this.populateRestServiceHeaders(service, accessTokenValue);
            service = this.populateEndPointUrl(service, instanceUrl);
        } else {
            LOGGER.info((Object)("Backend tokens are not supported for this service type : " + this.getService().getServiceType()));
        }
        return service;
    }

    private Service populateEndPointUrl(Service service, String instanceUrl) {
        ConfigParam endPointParam;
        LOGGER.debug((Object)"Populating the Instance URL in the Endpoint URL");
        if (this.getDataControllerRequest() != null) {
            this.getDataControllerRequest().setAttribute("instance_url", (Object)instanceUrl);
        }
        if ((endPointParam = service.getServiceConfig().getConfigParam("endpointUrl")) != null && StringUtils.isNotBlank((String)endPointParam.getValue())) {
            String newEndPointUrl = MiddlewareUtils.replaceHostNameInURL(endPointParam.getValue(), instanceUrl);
            if (this.getDataControllerRequest() != null) {
                this.getDataControllerRequest().setAttribute("endpointUrl", (Object)newEndPointUrl);
            } else {
                endPointParam.setValue(newEndPointUrl);
                service.getServiceConfig().getServiceConfig().add(endPointParam);
            }
        }
        return service;
    }

    private Service populateRestServiceHeaders(Service service, String authTokenValue) {
        LOGGER.debug((Object)"Populating the SFDC Rest Header values");
        if (this.getDataControllerRequest() != null) {
            HashMap<String, String> headersMap = new HashMap<String, String>();
            headersMap.put("Authorization", "Bearer " + authTokenValue);
            this.getDataControllerRequest().setAttribute("IDENTITY_HEADERS", headersMap);
        } else {
            this.addServiceHeaders(service, "Authorization", "Bearer " + authTokenValue, "request");
        }
        return service;
    }
}

