/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.integration.adapter;

import com.kony.adapter.commons.utils.ZipHelper;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.integration.exceptions.IntegrationAdapterException;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.asset.AssetManager;
import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.asset.AssetUtil;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.registry.impl.ApplicationHelper;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.KonyAppCache;
import com.konylabs.middleware.registry.vo.Application;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.apache.commons.text.StrSubstitutor;
import org.apache.log4j.Logger;

public class IntegrationAdapterCacheManager {
    private final Set<AppVersion> allAppVersions = new HashSet<AppVersion>();
    private static final Logger LOGGER = Logger.getLogger(IntegrationAdapterCacheManager.class);
    private static final Path INTEGRATION_TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "Integration");
    private static final DirectoryStream.Filter<Path> folderFilter = IntegrationAdapterCacheManager.getDirectoryFilter();
    private static final DirectoryStream.Filter<Path> fileFilter = IntegrationAdapterCacheManager.getFileFilter();
    private final KonyAppCache integrationAppCache = new KonyAppCache();

    public IntegrationAdapterCacheManager(InputStream zipName, Map<String, Object> placeHolders) throws IntegrationAdapterException {
        if (!Files.exists(INTEGRATION_TEMP_DIR, new LinkOption[0])) {
            INTEGRATION_TEMP_DIR.toFile().mkdir();
        }
        this.processZipAndLoadAllApplicationMetadatas(zipName, placeHolders);
    }

    private static DirectoryStream.Filter<Path> getDirectoryFilter() {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory(entry, new LinkOption[0]);
            }
        };
    }

    private static DirectoryStream.Filter<Path> getFileFilter() {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isRegularFile(entry, new LinkOption[0]);
            }
        };
    }

    KonyAppCache getCache() {
        return this.integrationAppCache;
    }

    public List<ApplicationMetadata> getApplicationMetadataList() {
        ArrayList<ApplicationMetadata> applicationMetadataList = new ArrayList<ApplicationMetadata>();
        for (AppVersion appVersion : this.allAppVersions) {
            applicationMetadataList.add(this.integrationAppCache.getAppMetadata(appVersion));
        }
        return applicationMetadataList;
    }

    public ApplicationMetadata getApplicationMetadata(String applicationId, String appVersion) {
        return this.integrationAppCache.getAppMetadata(new AppVersion(applicationId, appVersion));
    }

    private List<ApplicationMetadata> processZipAndLoadAllApplicationMetadatas(InputStream asset, Map<String, Object> placeHolders) throws IntegrationAdapterException {
        ArrayList<ApplicationMetadata> listToReturn = new ArrayList<ApplicationMetadata>();
        Path appsDirectory = this.extractZip(asset);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(appsDirectory, folderFilter);){
            for (Path appRoot : stream) {
                if (appRoot.endsWith("lib")) continue;
                Path servicesDirInAppRoot = appRoot.resolve("services");
                Path serviceDefPath = servicesDirInAppRoot.resolve(appRoot.getFileName() + ".xml");
                IntegrationAdapterCacheManager.replaceDynamicConnectionProperties(serviceDefPath, placeHolders);
                Application application = this.selectApplication(Files.newInputStream(serviceDefPath, new OpenOption[0]));
                AppVersion appVersion = ApplicationHelper.getAppVersionFromApplication(application);
                ApplicationHelper.prepareAppMetadata(application, this.integrationAppCache, appVersion);
                this.allAppVersions.add(appVersion);
                DataAdapterCache dataAdapterCache = new DataAdapterCache();
                dataAdapterCache.getUpdatedOrCreatedServices().add(appVersion);
                this.populateAssets(appVersion, servicesDirInAppRoot, dataAdapterCache);
                DataAdapterUtil.performAdapterIntialization(this.integrationAppCache, dataAdapterCache);
            }
        }
        catch (DataAdapterException | IOException e) {
            throw new IntegrationAdapterException("Failed while reading the directory " + appsDirectory, e);
        }
        return listToReturn;
    }

    private Path extractZip(InputStream asset) throws IntegrationAdapterException {
        try {
            return ZipHelper.unzipFile((ZipInputStream)new ZipInputStream(asset), (Path)INTEGRATION_TEMP_DIR);
        }
        catch (DataAdapterException e) {
            LOGGER.error((Object)"Error in unzipping the zip file", (Throwable)e);
            throw new IntegrationAdapterException("Error in unzipping the zip file", (Throwable)e);
        }
    }

    private void populateAssets(AppVersion appVersion, Path servicesDirInAppRoot, DataAdapterCache dataAdapterCache) throws IntegrationAdapterException {
        try (DirectoryStream<Path> assetStream = Files.newDirectoryStream(servicesDirInAppRoot, folderFilter);){
            for (Path assetDir : assetStream) {
                dataAdapterCache.getUpdatedAssets().add(appVersion);
                AssetManager assetManager = AssetType.getAssetManager(assetDir.getFileName().toString());
                this.loadAllAssetsInDirectory(appVersion, assetDir, assetManager, dataAdapterCache);
            }
        }
        catch (IOException e) {
            throw new IntegrationAdapterException("Error while populating asstes in " + servicesDirInAppRoot, (Throwable)e);
        }
    }

    private void loadAllAssetsInDirectory(AppVersion appVersion, Path assetDir, AssetManager assetManager, DataAdapterCache dataAdapterCache) throws IOException {
        try (DirectoryStream<Path> assetsStream = Files.newDirectoryStream(assetDir, fileFilter);){
            for (Path asset : assetsStream) {
                byte[] assetData = Files.readAllBytes(asset);
                String prefix = AssetUtil.getAssetPrefix(appVersion.getAppId(), appVersion.getVersion());
                assetManager.loadAsset(prefix + asset.getFileName().toString(), appVersion, assetData, this.integrationAppCache, dataAdapterCache);
            }
        }
    }

    private Application selectApplication(InputStream inputStream) throws IntegrationAdapterException {
        try {
            return ApplicationHelper.buildApplication(inputStream);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in unmarshalling xml file.", (Throwable)e);
            throw new IntegrationAdapterException("Error in unmarshalling xml file", (Throwable)e);
        }
    }

    private static void replaceDynamicConnectionProperties(Path path, Map<String, Object> placeHolders) throws IntegrationAdapterException {
        try {
            String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            content = IntegrationAdapterCacheManager.processAndReplacePlaceHolders(content, placeHolders);
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException exp) {
            throw new IntegrationAdapterException("Failed while replacing Dynamic Connection Properties", (Throwable)exp);
        }
    }

    public static String processAndReplacePlaceHolders(String content, Map<String, Object> placeHoldersMap) {
        StrSubstitutor strSubstitutor = new StrSubstitutor(placeHoldersMap);
        return strSubstitutor.replace(content);
    }
}

