/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.integration.adapter;

import com.kony.adapter.annotations.binary.BinaryData;
import com.kony.adapter.criteria.BatchContext;
import com.kony.adapter.criteria.BufferBatchContext;
import com.kony.adapter.criteria.Criteria;
import com.kony.adapter.criteria.PaginationBatchContext;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.metadata.model.FieldType;
import com.kony.adapter.metadata.model.RelationType;
import com.kony.adapter.model.Context;
import com.kony.adapter.model.Entity;
import com.kony.adapter.model.EntityList;
import com.kony.adapter.util.criteria.CriteriaToStringUtil;
import com.kony.integration.adapter.IntegrationAdapterFacade;
import com.kony.integration.connection.ApplicationConnectionManager;
import com.kony.integration.exceptions.IntegrationAdapterException;
import com.kony.integration.metadata.model.FieldMetadata;
import com.kony.integration.metadata.model.IntegrationObject;
import com.kony.integration.metadata.model.IntegrationObjectEntity;
import com.kony.integration.metadata.model.IntegrationObjectGroup;
import com.kony.integration.metadata.model.IntegrationService;
import com.kony.integration.metadata.model.RelatedFields;
import com.kony.integration.metadata.model.RelationshipMetadata;
import com.kony.integration.params.ArrayMetadata;
import com.kony.integration.params.CustomMetadata;
import com.kony.integration.params.ObjectMetadata;
import com.kony.integration.params.PrimitiveMetaData;
import com.konylabs.middleware.common.BinaryOperandAttributes;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.controller.impl.DataControllerRequestImpl;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.integration.adapter.IntegrationAdapterCacheManager;
import com.konylabs.middleware.integration.adapter.ServiceExecutor;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.monitoring.MonitoringProperties;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Field;
import com.konylabs.middleware.registry.vo.Fieldparam;
import com.konylabs.middleware.registry.vo.Fields;
import com.konylabs.middleware.registry.vo.Keyfield;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.registry.vo.Relation;
import com.konylabs.middleware.registry.vo.Relationfield;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.ServiceInput;
import com.konylabs.middleware.registry.vo.ServiceOutput;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.log4j.Logger;

public class IntegrationAdapterHelper
implements IntegrationAdapterFacade {
    private static final Logger LOGGER = Logger.getLogger(IntegrationAdapterHelper.class);
    private IntegrationAdapterCacheManager integrationAdapterCacheManager;

    public IntegrationAdapterHelper(InputStream zipName, Map<String, Object> placeHolders) throws IntegrationAdapterException {
        this.integrationAdapterCacheManager = new IntegrationAdapterCacheManager(zipName, placeHolders);
        ServiceExecutor.init();
    }

    public IntegrationAdapterHelper() {
    }

    public IntegrationAdapterCacheManager getIntegrationAdapterCacheManager() {
        return this.integrationAdapterCacheManager;
    }

    public void read(ApplicationConnectionManager appConnectionManager, IntegrationObject integrationObject, EntityList entityList, Criteria criteria, Context context) throws IntegrationAdapterException {
        String groupName = integrationObject.getApplicationId();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        try {
            String oDataString = CriteriaToStringUtil.criteriaToString((Criteria)criteria, null);
            Result result = this.prepareDcrAndExecuteService(integrationObject, entityMap, groupName, oDataString, "get", context);
            if (result != null) {
                if (IntegrationAdapterHelper.errorExists(result)) {
                    throw new IntegrationAdapterException("Read operation failed on  " + integrationObject.getObjectId() + ". Error Message " + result.getParamByName("errmsg").getValue());
                }
                IntegrationAdapterHelper.resultToEntityList(result, entityList, integrationObject);
            }
        }
        catch (IntegrationAdapterException e) {
            throw e;
        }
        catch (DataAdapterException e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new IntegrationAdapterException("Read operation failed on " + integrationObject.getObjectId(), (Throwable)e);
        }
    }

    public void create(ApplicationConnectionManager appConnectionManager, IntegrationObject integrationObject, Entity entity, Context context) throws IntegrationAdapterException {
        this.performOperation(integrationObject, entity, "create", context);
    }

    public void update(ApplicationConnectionManager appConnectionManager, IntegrationObject integrationObject, Entity entity, Context context) throws IntegrationAdapterException {
        this.performOperation(integrationObject, entity, "update", context);
    }

    public void delete(ApplicationConnectionManager appConnectionManager, IntegrationObject integrationObject, Entity entity, Context context) throws IntegrationAdapterException {
        this.performOperation(integrationObject, entity, "delete", context);
    }

    public void getAllServices(List<IntegrationObjectGroup> metadataList) throws IntegrationAdapterException {
        for (ApplicationMetadata applicationMetadata : this.integrationAdapterCacheManager.getApplicationMetadataList()) {
            metadataList.add(new IntegrationObjectGroup(applicationMetadata.getApplicationVersion().getAppId()));
        }
    }

    public void getAllObjectsFromService(List<IntegrationObject> objectMetadataList, IntegrationObjectGroup integrationObjectGroup) throws IntegrationAdapterException {
        ApplicationMetadata applicationMetadata = this.getAppMetadata(integrationObjectGroup.getApplicationId());
        if (applicationMetadata != null) {
            for (String objectName : applicationMetadata.getObjectNames()) {
                com.konylabs.middleware.registry.vo.Object object = applicationMetadata.getObjectMetadata(objectName).getServiceDefObject();
                objectMetadataList.add(new IntegrationObject(objectName, objectName, objectName, object.getId(), applicationMetadata.getApplicationVersion().getAppId()));
            }
        }
    }

    public void fillRelationsForObjects(com.konylabs.middleware.registry.vo.Object object, List<RelationshipMetadata> relationshipMetadataList, ApplicationMetadata applicationMetadata) {
        List relationsList = object.getRelations().getRelation();
        for (Relation relation : relationsList) {
            RelationshipMetadata relationshipMetadata = new RelationshipMetadata();
            relationshipMetadata.setName(relation.getName());
            relationshipMetadata.setCascadeDelete(relation.isCascade());
            relationshipMetadata.setRelatedFieldMetadata(this.setRelatedFields(relation));
            relationshipMetadata.setTargetEntity(this.setTargetentity(relation, applicationMetadata));
            relationshipMetadata.setRelationType(RelationType.getByConsoleType((String)relation.getType()));
            relationshipMetadataList.add(relationshipMetadata);
        }
    }

    private IntegrationObject setTargetentity(Relation relation, ApplicationMetadata appMeta) {
        String targetObjectID = appMeta.getObjectMetadata(relation.getTargetObject()).getId();
        String objectDetails = relation.getTargetObject();
        return new IntegrationObject(objectDetails, objectDetails, objectDetails, targetObjectID, appMeta.getApplicationVersion().getAppId());
    }

    public List<RelatedFields> setRelatedFields(Relation relation) {
        ArrayList<RelatedFields> relatedFieldsList = new ArrayList<RelatedFields>();
        List reationFieldList = relation.getRelationFields().getRelationField();
        for (Relationfield relationfield : reationFieldList) {
            RelatedFields relatedFields = new RelatedFields();
            relatedFields.setSourceField(new FieldMetadata(relationfield.getSourceField()));
            relatedFields.setTargetField(new FieldMetadata(relationfield.getTargetField()));
            relatedFieldsList.add(relatedFields);
        }
        return relatedFieldsList;
    }

    public void fillFieldsForObject(com.konylabs.middleware.registry.vo.Object currentObject, List<FieldMetadata> fieldMetadataList) {
        Fields fields = currentObject.getFields();
        List fieldList = fields.getField();
        ArrayList<String> keyFieldList = new ArrayList<String>();
        for (Keyfield keyField : currentObject.getKey().getKeyField()) {
            keyFieldList.add(keyField.getName());
        }
        for (Field field : fieldList) {
            FieldMetadata fieldMetaData = IntegrationAdapterHelper.setFieldMetaDataValues(field);
            if (keyFieldList.contains(field.getName())) {
                fieldMetaData.setPrimary(true);
            }
            fieldMetadataList.add(fieldMetaData);
        }
    }

    public void getObjectDetails(IntegrationObject objectMetadata, List<FieldMetadata> fieldMetadataList, List<RelationshipMetadata> relationshipMetadata) throws IntegrationAdapterException {
        ApplicationMetadata applicationMetadata = this.getAppMetadata(objectMetadata.getApplicationId());
        com.konylabs.middleware.registry.vo.Object currentObject = applicationMetadata.getObjectMetadata(objectMetadata.getObjectId()).getServiceDefObject();
        this.fillFieldsForObject(currentObject, fieldMetadataList);
        this.fillRelationsForObjects(currentObject, relationshipMetadata, applicationMetadata);
        this.populateSupportedVerbs(applicationMetadata, objectMetadata);
    }

    private void populateSupportedVerbs(ApplicationMetadata applicationMetadata, IntegrationObject objectMetadata) {
        Map<String, Operationmapping> operationsMap = applicationMetadata.getOperatonMapingByObjectId(objectMetadata.getObjectId());
        objectMetadata.setSupportedVerbs(operationsMap.keySet());
    }

    public void getAllServicesFromApplication(List<IntegrationService> metadataList, IntegrationObjectGroup integrationObjectGroup) throws IntegrationAdapterException {
        ApplicationMetadata applicationMetadata = this.getAppMetadata(integrationObjectGroup.getApplicationId());
        for (String serviceId : applicationMetadata.getServiceNames()) {
            IntegrationService integrationService = new IntegrationService();
            integrationService.setApplicationId(applicationMetadata.getApplicationVersion().getAppId());
            integrationService.setServiceName(serviceId);
            integrationService.setDescription(serviceId);
            integrationService.setServiceId(serviceId);
            integrationService.setDisplayName(serviceId);
            metadataList.add(integrationService);
        }
    }

    public void getServiceDetails(ApplicationConnectionManager appConnectionManager, IntegrationService integrationService) throws IntegrationAdapterException {
        ApplicationMetadata applicationMetadata = this.getAppMetadata(integrationService.getApplicationId());
        Service service = applicationMetadata.getServiceMetadata(integrationService.getServiceId()).getService();
        ServiceInput serviceInput = service.getServiceInput();
        IntegrationAdapterHelper.addParamDatasetAndRecords(integrationService.getInputTypes(), serviceInput.getParams(), serviceInput.getDatasets(), serviceInput.getRecords(), appConnectionManager);
        ServiceOutput serviceOutput = service.getServiceOutput();
        IntegrationAdapterHelper.addParamDatasetAndRecords(integrationService.getOutputTypes(), serviceOutput.getParams(), serviceOutput.getDatasets(), serviceOutput.getRecords(), appConnectionManager);
    }

    public void invokeService(IntegrationService integrationService, Map<String, Object> inputMap, ApplicationConnectionManager appConnectionManager, Context context, Map<String, Object> result) throws IntegrationAdapterException {
        String applicationId = integrationService.getApplicationId();
        String serviceId = integrationService.getServiceId();
        if (appConnectionManager.getDynamicConnectionProperties() != null) {
            inputMap.putAll(appConnectionManager.getDynamicConnectionProperties());
        }
        DataControllerRequestImpl dcRequest = new DataControllerRequestImpl(inputMap, context.getAllSessionTokens());
        IntegrationAdapterHelper.addMetricsBeanAndParentTimerNameToDcr(context, dcRequest);
        DataControllerResponse dcResponse = ServiceExecutor.executeService(serviceId, dcRequest, applicationId, this.integrationAdapterCacheManager, context);
        if (this.isResponsePassThrough(applicationId, serviceId)) {
            BinaryData binaryData = this.prepareBinaryDataFromResponse(dcRequest, dcResponse);
            result.put("binaryKey", binaryData);
        } else {
            result.putAll(this.convertResultToMap((Result)dcRequest.getAttribute("results")));
        }
    }

    public BinaryData readBinary(ApplicationConnectionManager appManager, IntegrationObject integrationObject, Map<String, Object> inputParams, Context context, BigInteger startPostion, BigInteger endPosition, Criteria criteria) throws IntegrationAdapterException {
        String groupName = integrationObject.getApplicationId();
        try {
            String oDataString = CriteriaToStringUtil.criteriaToString((Criteria)criteria, null);
            BinaryData binaryData = this.prepareDcrAndExecuteBinaryDownloadService(integrationObject, inputParams, groupName, oDataString, "getBinary", context);
            return binaryData;
        }
        catch (IntegrationAdapterException e) {
            throw e;
        }
        catch (DataAdapterException e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new IntegrationAdapterException("Binary read operation failed on " + integrationObject.getObjectId(), (Throwable)e);
        }
    }

    public void createBinary(ApplicationConnectionManager appManager, IntegrationObject integrationObject, Map<String, Object> inputParams, Context context, BinaryData binaryData) throws IntegrationAdapterException {
        this.performBinaryOperation(integrationObject, inputParams, context, binaryData, "createBinary");
    }

    public void updateBinary(ApplicationConnectionManager appManager, IntegrationObject integrationObject, Map<String, Object> inputParams, Context context, BinaryData binaryData) throws IntegrationAdapterException {
        this.performBinaryOperation(integrationObject, inputParams, context, binaryData, "updateBinary");
    }

    public void deleteBinary(ApplicationConnectionManager appManager, IntegrationObject integrationObject, Map<String, Object> inputParams, Context context) throws IntegrationAdapterException {
        this.performBinaryOperation(integrationObject, inputParams, context, null, "deleteBinary");
    }

    public void close() {
        if (this.integrationAdapterCacheManager != null) {
            this.integrationAdapterCacheManager = null;
        }
    }

    private Result prepareDcrAndExecuteService(IntegrationObject integrationObject, Map<String, Object> entityMap, String groupName, String oDataString, String operation, Context context) throws IntegrationAdapterException {
        DataControllerRequest dcRequest = IntegrationAdapterHelper.prepareDataControllerRequest(entityMap, oDataString, context);
        this.getResult(integrationObject, groupName, operation, context, dcRequest);
        return (Result)dcRequest.getAttribute("results");
    }

    private BinaryData prepareDcrAndExecuteBinaryDownloadService(IntegrationObject integrationObject, Map<String, Object> entityMap, String groupName, String oDataString, String operationName, Context context) throws IntegrationAdapterException {
        DataControllerRequest dcRequest = IntegrationAdapterHelper.prepareDataControllerRequest(entityMap, oDataString, context);
        DataControllerResponse response = this.getResult(integrationObject, groupName, operationName, context, dcRequest);
        return this.prepareBinaryDataFromResponse(dcRequest, response);
    }

    private BinaryData prepareBinaryDataFromResponse(DataControllerRequest dcRequest, DataControllerResponse response) throws IntegrationAdapterException {
        BinaryData bData = null;
        Result result = (Result)dcRequest.getAttribute("results");
        int opstatus = 0;
        if (ServiceExecutor.isParamPresentInResult(result, "opstatus")) {
            opstatus = Integer.parseInt(result.getParamByName("opstatus").getValue());
        }
        Object binaryResponse = response.getAttribute("chunkedresults_json");
        if (opstatus != 0) {
            bData = new BinaryData(IOUtils.toInputStream((String)String.valueOf(binaryResponse)));
        } else if (InputStream.class.isAssignableFrom(binaryResponse.getClass())) {
            bData = new BinaryData((InputStream)binaryResponse);
        } else if (binaryResponse instanceof BufferedHttpEntity) {
            try {
                bData = new BinaryData(((BufferedHttpEntity)binaryResponse).getContent());
            }
            catch (IOException e) {
                throw new IntegrationAdapterException("Error while reading the stream from the response", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)String.valueOf(response.getAttribute(BinaryOperandAttributes.fieldName.name())))) {
            bData.setName(String.valueOf(response.getAttribute(BinaryOperandAttributes.fieldName.name())));
        }
        if (StringUtils.isNotBlank((String)String.valueOf(response.getAttribute(BinaryOperandAttributes.fileName.name())))) {
            bData.setOriginalFileName(String.valueOf(response.getAttribute(BinaryOperandAttributes.fileName.name())));
        }
        return bData;
    }

    private void prepareDcrAndExecuteBinaryService(IntegrationObject integrationObject, Map<String, Object> entityMap, String groupName, String oDataString, String operationName, Context context, BinaryData binaryData) throws IntegrationAdapterException {
        DataControllerRequest dcRequest = IntegrationAdapterHelper.prepareBinaryDataControllerRequest(entityMap, oDataString, context, binaryData);
        this.getResult(integrationObject, groupName, operationName, context, dcRequest);
    }

    private DataControllerResponse getResult(IntegrationObject integrationObject, String groupName, String operation, Context context, DataControllerRequest dcRequest) throws IntegrationAdapterException {
        String serviceId = this.getServiceId(integrationObject, operation);
        return ServiceExecutor.executeService(serviceId, dcRequest, groupName, this.integrationAdapterCacheManager, context);
    }

    private String getServiceId(IntegrationObject integrationObject, String operation) {
        ApplicationMetadata applicationMetadata = this.getAppMetadata(integrationObject.getApplicationId());
        return applicationMetadata.getOperatonMapingByObjectId(integrationObject.getObjectId()).get(operation).getServiceid();
    }

    static DataControllerRequest prepareDataControllerRequest(Map<String, Object> entityMap, String oDataString, Context context) {
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        headersMap.putAll(context.getAllSessionTokens());
        DataControllerRequestImpl dcRequest = new DataControllerRequestImpl(entityMap, headersMap);
        if (!StringUtils.isEmpty((String)oDataString)) {
            String[] queryParamsArray;
            for (String queryParam : queryParamsArray = oDataString.split("&")) {
                if (!queryParam.contains("=")) continue;
                String[] queryParamaters = queryParam.split("=");
                dcRequest.addRequestParam_(queryParamaters[0].trim(), queryParamaters[1].trim());
            }
        }
        IntegrationAdapterHelper.addBatchContextToDcr(context, dcRequest);
        IntegrationAdapterHelper.addMetricsBeanAndParentTimerNameToDcr(context, dcRequest);
        return dcRequest;
    }

    private static void addMetricsBeanAndParentTimerNameToDcr(Context context, DataControllerRequest dcRequest) {
        DataControllerRequest originalDcr = (DataControllerRequest)context.get("request");
        if (originalDcr != null && originalDcr.getAttribute("metricsBean") != null) {
            MetricsBean originalMetricsBean = (MetricsBean)originalDcr.getAttribute("metricsBean");
            dcRequest.setAttribute("metricsBean", (Object)originalMetricsBean);
            dcRequest.setAttribute(MonitoringProperties.PARENT_TIMER_NAME.getName(), (Object)originalMetricsBean.getParentTimerName());
        }
    }

    private static void addBatchContextToDcr(Context context, DataControllerRequest dcRequest) {
        BatchContext contextType = context.getBatchContext();
        if (contextType == null) {
            return;
        }
        if (contextType instanceof PaginationBatchContext) {
            PaginationBatchContext batchContext = (PaginationBatchContext)contextType;
            long skip = batchContext.getBatchPointerLong();
            long top = batchContext.getPageSize();
            dcRequest.addRequestParam_("$top", String.valueOf(top));
            dcRequest.addRequestParam_("$skip", String.valueOf(skip));
        } else {
            BufferBatchContext batchContext = (BufferBatchContext)contextType;
            String batchPointer = batchContext.getBatchPointer();
            long bufferSize = batchContext.getBufferSize();
            dcRequest.addRequestParam_("$batchsize", String.valueOf(bufferSize));
            dcRequest.addRequestParam_("$batchid", batchPointer);
        }
    }

    private static DataControllerRequest prepareBinaryDataControllerRequest(Map<String, Object> entityMap, String oDataString, Context context, BinaryData binaryData) {
        DataControllerRequest dcRequest = IntegrationAdapterHelper.prepareDataControllerRequest(entityMap, oDataString, context);
        dcRequest.setAttribute("binaryKey", (Object)binaryData);
        dcRequest.setAttribute(BinaryOperandAttributes.fieldName.name(), (Object)binaryData.getName());
        dcRequest.setAttribute(BinaryOperandAttributes.fileName.name(), (Object)binaryData);
        dcRequest.setAttribute("passThruHttpEntity", (Object)binaryData.getInputStream());
        return dcRequest;
    }

    private static void entityToMapConversion(Entity entity, Map<String, Object> entityMap) {
        for (String fieldName : entity.getFieldNames()) {
            entityMap.put(fieldName, entity.getFieldValue(fieldName));
        }
    }

    private static boolean errorExists(Result result) {
        return result.getParamByName("errmsg") != null && StringUtils.isNotEmpty((String)result.getParamByName("errmsg").getValue());
    }

    private static void resultToEntityList(Result result, EntityList entityList, IntegrationObject integrationObject) {
        for (com.konylabs.middleware.dataobject.Record record : result.getDatasetById(integrationObject.getObjectId()).getAllRecords()) {
            entityList.addEntity(IntegrationAdapterHelper.recordToEnity(record, integrationObject, null));
        }
    }

    private static Entity recordToEnity(com.konylabs.middleware.dataobject.Record record, IntegrationObject integrationObject, Entity entity) {
        if (entity == null) {
            entity = new IntegrationObjectEntity(record.getId());
        }
        for (com.konylabs.middleware.dataobject.Param param : record.getAllParams()) {
            entity.setFieldValue(param.getName(), (Object)param.getValue());
        }
        for (com.konylabs.middleware.dataobject.Dataset dataSet : record.getAllDatasets()) {
            EntityList relatedEntityList = new EntityList();
            for (com.konylabs.middleware.dataobject.Record downRecord : dataSet.getAllRecords()) {
                Entity relatedEntity = IntegrationAdapterHelper.recordToEnity(downRecord, integrationObject, null);
                relatedEntityList.addEntity(relatedEntity);
            }
            entity.setRelatedEntities(dataSet.getId(), relatedEntityList);
        }
        return entity;
    }

    private void performOperation(IntegrationObject integrationObject, Entity entity, String operation, Context context) throws IntegrationAdapterException {
        String groupName = integrationObject.getApplicationId();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        IntegrationAdapterHelper.entityToMapConversion(entity, entityMap);
        Result result = this.prepareDcrAndExecuteService(integrationObject, entityMap, groupName, "", operation, context);
        if (result != null && !"delete".equalsIgnoreCase(operation)) {
            com.konylabs.middleware.dataobject.Record record = result.getDatasetById(integrationObject.getObjectId()).getRecord(0);
            IntegrationAdapterHelper.recordToEnity(record, integrationObject, entity);
        }
    }

    private void performBinaryOperation(IntegrationObject integrationObject, Map<String, Object> inputParams, Context context, BinaryData binaryData, String operationName) throws IntegrationAdapterException {
        String groupName = integrationObject.getApplicationId();
        this.prepareDcrAndExecuteBinaryService(integrationObject, inputParams, groupName, "", operationName, context, binaryData);
    }

    private static FieldMetadata setFieldMetaDataValues(Field field) {
        FieldMetadata fieldMetaData = new FieldMetadata();
        fieldMetaData.setName(field.getName());
        fieldMetaData.setDisplayName(field.getDisplayName());
        List fieldParams = field.getFieldParam();
        long length = 0L;
        long precision = 0L;
        boolean isCreatable = false;
        boolean isCustomizable = false;
        boolean isNullable = false;
        boolean isUpdatable = false;
        boolean isAutoGenerated = false;
        block18: for (int index = 0; index < fieldParams.size(); ++index) {
            switch (((Fieldparam)fieldParams.get(index)).getName()) {
                case "customizable": {
                    isCustomizable = Boolean.valueOf(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
                case "updateable": {
                    isUpdatable = Boolean.valueOf(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
                case "nullable": {
                    isNullable = Boolean.valueOf(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
                case "creatable": {
                    isCreatable = Boolean.valueOf(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
                case "autoGenerated": {
                    isAutoGenerated = Boolean.valueOf(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
                case "fieldlength": {
                    length = new Long(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
                case "precision": {
                    precision = new Long(((Fieldparam)fieldParams.get(index)).getValue());
                    continue block18;
                }
            }
        }
        fieldMetaData.setCreatable(isCreatable);
        fieldMetaData.setNullable(isNullable);
        fieldMetaData.setUpdatable(isUpdatable);
        fieldMetaData.setCustomizable(isCustomizable);
        fieldMetaData.setAutoGenerated(isAutoGenerated);
        fieldMetaData.setLength(length);
        fieldMetaData.setPrecision(precision);
        if ("NUMBER".equals(field.getDatatype().toUpperCase())) {
            fieldMetaData.setFieldType(FieldType.valueOf((String)"DOUBLE"));
        } else {
            fieldMetaData.setFieldType(FieldType.valueOf((String)field.getDatatype().toUpperCase()));
        }
        return fieldMetaData;
    }

    private Map<String, Object> convertResultToMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (com.konylabs.middleware.dataobject.Param param : result.getAllParams()) {
            resultMap.put(param.getName(), param.getObjectValue());
        }
        for (com.konylabs.middleware.dataobject.Record record : result.getAllRecords()) {
            resultMap.put(record.getId(), this.convertRecordToMap(record));
        }
        for (com.konylabs.middleware.dataobject.Dataset dataset : result.getAllDatasets()) {
            resultMap.put(dataset.getId(), this.convertDatasetToList(dataset));
        }
        return resultMap;
    }

    private Object convertDatasetToList(com.konylabs.middleware.dataobject.Dataset dataset) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (com.konylabs.middleware.dataobject.Record record : dataset.getAllRecords()) {
            resultList.add(this.convertRecordToMap(record));
        }
        return resultList;
    }

    private Object convertRecordToMap(com.konylabs.middleware.dataobject.Record record) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (com.konylabs.middleware.dataobject.Param param : record.getAllParams()) {
            resultMap.put(param.getName(), param.getValue());
        }
        for (com.konylabs.middleware.dataobject.Record childRecord : record.getAllRecords()) {
            resultMap.put(childRecord.getId(), this.convertRecordToMap(childRecord));
        }
        for (com.konylabs.middleware.dataobject.Dataset dataset : record.getAllDatasets()) {
            resultMap.put(dataset.getId(), this.convertDatasetToList(dataset));
        }
        return resultMap;
    }

    public static void addParamDatasetAndRecords(List<Object> list, List<Param> params, List<Dataset> datasets, List<Record> records, ApplicationConnectionManager appConnectionManager) {
        if (CollectionUtils.isNotEmpty(params)) {
            for (Param param : params) {
                if (appConnectionManager.isDynamicConnectionProperty(param.getName())) continue;
                list.add(IntegrationAdapterHelper.createPrimitveMetaDataFromParam(param));
            }
        }
        if (CollectionUtils.isNotEmpty(datasets)) {
            for (Dataset dataset : datasets) {
                list.add(IntegrationAdapterHelper.createArrayMetadataFromDataSet(dataset));
            }
        }
        if (CollectionUtils.isNotEmpty(records)) {
            for (Record record : records) {
                list.add(IntegrationAdapterHelper.createObjectMetadata(record));
            }
        }
    }

    private static CustomMetadata createPrimitveMetaDataFromParam(Param param) {
        if ("COLLECTION".equals(param.getDataType().toUpperCase())) {
            return new ArrayMetadata(param.getName());
        }
        PrimitiveMetaData primitiveMetaData = new PrimitiveMetaData(param.getName(), IntegrationAdapterHelper.convertDataTypeToFieldType(param.getDataType().toUpperCase()));
        return primitiveMetaData;
    }

    private static FieldType convertDataTypeToFieldType(String dataType) {
        if ("NUMBER".equals(dataType)) {
            return FieldType.valueOf((String)"DOUBLE");
        }
        return FieldType.valueOf((String)dataType);
    }

    private static ArrayMetadata createArrayMetadataFromDataSet(Dataset dataset) {
        ArrayMetadata arrayMetadata = new ArrayMetadata(dataset.getId());
        ArrayList params = dataset.getParams();
        ArrayList records = dataset.getRecords();
        ArrayList datasets = dataset.getDatasets();
        for (Param innerparam : params) {
            arrayMetadata.addElements((Object)IntegrationAdapterHelper.createPrimitveMetaDataFromParam(innerparam));
        }
        for (Record innerrecord : records) {
            arrayMetadata.addElements((Object)IntegrationAdapterHelper.createObjectMetadata(innerrecord));
        }
        for (Dataset innerdataset : datasets) {
            arrayMetadata.addElements((Object)IntegrationAdapterHelper.createArrayMetadataFromDataSet(innerdataset));
        }
        return arrayMetadata;
    }

    private static ObjectMetadata createObjectMetadata(Record record) {
        ObjectMetadata objectMetadata = new ObjectMetadata(record.getId());
        ArrayList params = record.getParams();
        ArrayList records = record.getRecords();
        ArrayList datasets = record.getDatasets();
        for (Param innerparam : params) {
            objectMetadata.addElements((Object)IntegrationAdapterHelper.createPrimitveMetaDataFromParam(innerparam));
        }
        for (Record innerrecord : records) {
            objectMetadata.addElements((Object)IntegrationAdapterHelper.createObjectMetadata(innerrecord));
        }
        for (Dataset innerdataset : datasets) {
            objectMetadata.addElements((Object)IntegrationAdapterHelper.createArrayMetadataFromDataSet(innerdataset));
        }
        return objectMetadata;
    }

    private boolean isResponsePassThrough(String applicationId, String serviceId) {
        return this.getAppMetadata(applicationId).getServiceMetadata(serviceId).getService().getServiceOutput().isPassthrough();
    }

    private ApplicationMetadata getAppMetadata(String appId) {
        return this.integrationAdapterCacheManager.getApplicationMetadata(appId, "1.0");
    }
}

