/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.integration.adapter;

import com.kony.adapter.criteria.BatchContext;
import com.kony.adapter.criteria.BufferBatchContext;
import com.kony.adapter.model.Context;
import com.kony.integration.exceptions.IntegrationAdapterException;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.controller.impl.DataControllerImpl;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ControllerException;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.integration.adapter.IntegrationAdapterCacheManager;
import com.konylabs.middleware.utilities.MaskUtils;
import org.apache.log4j.Logger;

final class ServiceExecutor {
    private static final Logger LOGGER;
    private static DataControllerImpl dataControllerImpl;

    private ServiceExecutor() {
    }

    static void init() throws IntegrationAdapterException {
        dataControllerImpl = (DataControllerImpl)DataController.InstanceManager.getInstance();
        try {
            dataControllerImpl.init();
        }
        catch (ControllerInitializationException cie) {
            MaskUtils.maskTrace((String)("\n IN ServiceExecutor - Controller Initialization Exception. Error code: " + cie.getErrorCode() + "\n"), (Throwable)cie);
            throw new IntegrationAdapterException("ServiceExecutor - Controller Initialization Exception", (Throwable)cie);
        }
    }

    static DataControllerResponse executeService(String serviceId, DataControllerRequest dcRequest, String appId, IntegrationAdapterCacheManager integrationAdapterCacheManager, Context context) throws IntegrationAdapterException {
        try {
            ServiceExecutor.setAppCacheAndTenantBean(dcRequest, integrationAdapterCacheManager, context);
            dcRequest.addRequestParam_("appID", appId);
            dcRequest.addRequestParam_("serviceID", serviceId);
            dcRequest.addRequestParam_("channel", "rc");
            DataControllerResponse response = dataControllerImpl.processDataRequest(dcRequest);
            context.put("httpStatusCode", (Object)response.getStatusCode());
            ServiceExecutor.handleBatchAttributes(dcRequest, context);
            return response;
        }
        catch (ControllerException | ControllerInitializationException e) {
            LOGGER.error((Object)e, e);
            throw new IntegrationAdapterException(e.getErrorCode(), "Failed to execute " + serviceId + "\n" + e.getMessage(), e.getHttpStatusCode());
        }
    }

    public static void setAppCacheAndTenantBean(DataControllerRequest dcRequest, IntegrationAdapterCacheManager integrationAdapterCacheManager, Context context) {
        dcRequest.setAttribute("appregistry_Cache", (Object)integrationAdapterCacheManager.getCache());
        dcRequest.setAttribute("tenantBean", context.get("tenantBean"));
    }

    public static void handleBatchAttributes(DataControllerRequest dcRequest, Context context) {
        Result result = (Result)dcRequest.getAttribute("results");
        if (ServiceExecutor.isRequestContainsAnyBatchParams(result)) {
            if (context.getBatchContext() == null) {
                context.setBatchContext((BatchContext)new BufferBatchContext());
            }
            if (context.getBatchContext().getBatchType() == BatchContext.BATCHTYPE.BUFFER_BASED) {
                BufferBatchContext bufferBCtx = (BufferBatchContext)BufferBatchContext.class.cast(context.getBatchContext());
                if (ServiceExecutor.isParamPresentInResult(result, "nextBatchId")) {
                    bufferBCtx.setBatchPointer(result.getParamByName("nextBatchId").getValue());
                }
                if (ServiceExecutor.isParamPresentInResult(result, "hasMoreRecords")) {
                    bufferBCtx.setMoreBufferAvailable(Boolean.parseBoolean(result.getParamByName("hasMoreRecords").getValue()));
                }
            }
        }
    }

    static boolean isParamPresentInResult(Result result, String key) {
        return result.getParamByName(key) != null;
    }

    private static boolean isRequestContainsAnyBatchParams(Result result) {
        return ServiceExecutor.isParamPresentInResult(result, "nextBatchId") || ServiceExecutor.isParamPresentInResult(result, "hasMoreRecords");
    }

    static {
        ConnectorUtils.initialize();
        LOGGER = Logger.getLogger(ServiceExecutor.class);
    }
}

