/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.js;

import com.kony.mapper.exception.MapperExceptionMessageWrapper;
import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.apache.log4j.Logger;

public final class JavaScriptExecutorUtil {
    private static final Logger LOGGER = Logger.getLogger(JavaScriptExecutorUtil.class);

    public static Object execute(JavaScriptEngineWrapper jsEngineWrapper, AppVersion appVersion, String script, ScriptContext scriptContext) throws ConnectorException {
        LOGGER.debug((Object)"Inside Java Script executor util.");
        try {
            String namespace = appVersion != null ? appVersion.toString() : "";
            return jsEngineWrapper.evalScript(script, scriptContext, namespace);
        }
        catch (Exception e) {
            String errorMsg = MapperExceptionMessageWrapper.getMaskedMessageForException((Exception)e);
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new ConnectorException("JavaScript error", "7010", errorMsg, (Throwable)e);
        }
    }

    public static ScriptContext createScriptContext(DataControllerRequest request, DataControllerResponse response, Result result, Map<String, Object> serviceInputParams, Logger logger) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        Bindings bindings = TenantUtilities.getJavaScriptEngineFromRequest(request).createBindings();
        bindings.put("request", (Object)request);
        bindings.put("result", (Object)result);
        bindings.put("response", (Object)response);
        bindings.put("serviceInputParams", (Object)serviceInputParams);
        bindings.put("logger", (Object)logger);
        scriptContext.setBindings(bindings, 100);
        return scriptContext;
    }

    private JavaScriptExecutorUtil() {
    }
}

