/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.logger;

import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.utilities.ConfigUtility;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;

@Plugin(name="systemconfig", category="Lookup")
public class SystemConfigLookup
implements StrLookup {
    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }

    public String lookup(String key) {
        String configValue = ConfigUtility.getProperty((String)key);
        if (StringUtils.isNotBlank((String)configValue)) {
            return configValue;
        }
        if (LoggerProperties.SERVER_LOG_FILE_NAME.nameEquals(key)) {
            return SystemConfigLookup.getLogFileName();
        }
        if ("SERVER_LOG_LOCATION".equals(key)) {
            return SystemConfigLookup.getLogLocation();
        }
        if (LoggerProperties.SERVER_LOG_OPTION.nameEquals(key)) {
            return (String)LoggerProperties.SERVER_LOG_OPTION.getFromConfig();
        }
        if (LoggerProperties.SERVER_LOG_LEVEL.nameEquals(key)) {
            return (String)LoggerProperties.SERVER_LOG_LEVEL.getFromConfig();
        }
        if (LoggerProperties.SERVER_LOGGER_JNDI_NAME.nameEquals(key)) {
            return (String)LoggerProperties.SERVER_LOGGER_JNDI_NAME.getFromConfig();
        }
        return configValue;
    }

    private static String getLogLocation() {
        String logFileLocation = null;
        logFileLocation = ConfigUtility.getBoolean((String)"IS_WEB_APP", (boolean)false) ? ConfigUtility.getProperty((String)"SPA_LOG_LOCATION", (String)(ConfigUtility.getProperty((String)"java.io.tmpdir") + "/konymflogs")) : System.getProperty("user.home") + "/konymflogs";
        return logFileLocation.replaceAll("\\\\", "/");
    }

    private static String getLogFileName() {
        if (ConfigUtility.getBoolean((String)"IS_WEB_APP", (boolean)false)) {
            return StringUtils.strip((String)ConfigUtility.getProperty((String)"context-path", (String)"SPA"), (String)"/") + "-middleware.log";
        }
        return (String)LoggerProperties.SERVER_SERVICES_LOG_FILE_NAME.getFromConfig();
    }
}

