/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.impl.json.JsonNode;
import com.kony.mapper.model.impl.json.JsonNodeList;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.controller.impl.AbstractDataControllerRequestImpl;
import com.konylabs.middleware.controller.impl.DataControllerRequestImpl;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class DCRNode
extends AbstractNode {
    private final AbstractDataControllerRequestImpl dcr;

    protected DCRNode(AbstractDataControllerRequestImpl dcr) {
        this.dcr = dcr;
    }

    public DCRNode(DataControllerRequestImpl dcr) {
        this((AbstractDataControllerRequestImpl)dcr);
    }

    public NodeElement getValue(String nodeName) {
        String fieldValue = this.dcr.getParameter(nodeName);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue.startsWith("{") || fieldValue.startsWith("[")) {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(fieldValue.trim()));
            jsonReader.setLenient(true);
            JsonParser jp = new JsonParser();
            JsonElement jsonElement = jp.parse(jsonReader);
            if (jsonElement.isJsonObject()) {
                return new JsonNode(jsonElement.getAsJsonObject());
            }
            if (jsonElement.isJsonArray()) {
                return new JsonNodeList(jsonElement.getAsJsonArray());
            }
            return new ObjectNodePrimitive((Object)fieldValue);
        }
        return new ObjectNodePrimitive((Object)fieldValue);
    }

    public void setValue(String key, NodeElement nodeElement) {
        this.dcr.addRequestParam_(key, nodeElement.toString());
    }

    public void remove(String key) {
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator itr = this.dcr.getParameterNames();
        while (itr.hasNext()) {
            keys.add((String)itr.next());
        }
        return keys;
    }

    protected AbstractDataControllerRequestImpl getDcr() {
        return this.dcr;
    }
}

