/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.mapper.model.AbstractNodeList;
import com.kony.mapper.model.NodeElement;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.mapper.IterableWrapper;
import com.konylabs.middleware.mapper.IteratorWrapper;
import com.konylabs.middleware.mapper.RecordNode;

public class DatasetNode
extends AbstractNodeList {
    private final Dataset dataset;

    public DatasetNode(String datasetId) {
        this(new Dataset());
        this.dataset.setId(datasetId);
    }

    public DatasetNode(Dataset dataset) {
        this.dataset = dataset;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void addNodeElement(NodeElement node) {
        if (node instanceof RecordNode) {
            RecordNode recNode = (RecordNode)node;
            this.dataset.addRecord(recNode.getRecord());
        }
    }

    public Iterable<NodeElement> getNodeElements() {
        if (this.dataset == null) {
            return null;
        }
        return new IterableWrapper<Record, NodeElement>(this.dataset.getRecords(), new IteratorWrapper.Converter<Record, NodeElement>(){

            @Override
            public NodeElement convert(Record src) {
                return new RecordNode(src);
            }
        });
    }
}

