/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.adapter.DataAdapter;
import com.kony.adapter.metadata.model.EntityMetadata;
import com.kony.adapter.metadata.model.RelationshipMetadata;
import com.kony.adapter.model.Entity;
import com.kony.mapper.model.AbstractNodeCreator;
import com.kony.mapper.model.Node;
import com.kony.mapper.model.NodeList;
import com.kony.mapper.model.NodePrimitive;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.mapper.EntityListNode;
import com.konylabs.middleware.mapper.EntityNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityNodeCreator
extends AbstractNodeCreator {
    private final DataAdapter dataAdapter;
    private final EntityMetadata rootEntityMetaData;
    private final Map<String, EntityMetadata> entityMetaDataMap = new HashMap<String, EntityMetadata>();

    public EntityNodeCreator(DataAdapter dataAdapter, EntityMetadata entityMetaData) {
        this.dataAdapter = dataAdapter;
        this.rootEntityMetaData = entityMetaData;
        this.populateEntityMetaData(this.rootEntityMetaData);
    }

    private void populateEntityMetaData(EntityMetadata entityMetadata) {
        if (entityMetadata != null) {
            this.entityMetaDataMap.put(entityMetadata.getName(), entityMetadata);
            List relationsShips = entityMetadata.getRelationships();
            if (relationsShips != null) {
                for (RelationshipMetadata meta : relationsShips) {
                    this.populateEntityMetaData(meta.getRelatedEntityMetaData());
                }
            }
        }
    }

    public Node createNode(String nodeName) {
        Entity entity = this.dataAdapter.createEntity(this.entityMetaDataMap.get(nodeName));
        return new EntityNode(entity);
    }

    public NodeList createNodeList(String nodeName) {
        return new EntityListNode();
    }

    public NodePrimitive createNodePrimitive(Object value) {
        return new ObjectNodePrimitive(value);
    }

    public Node createRootEntity() {
        Entity entity = this.dataAdapter.createEntity(this.rootEntityMetaData);
        return new EntityNode(entity);
    }
}

