/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayException;
import com.kony.mapper.exception.MapperRuntimeException;
import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.konylabs.middleware.mapper.MapNode;
import java.util.Map;
import java.util.Set;

public class IdentityProviderNode
extends AbstractNode {
    private final Gateway gateway;
    private final String providerName;

    public IdentityProviderNode(Gateway gateway, String providerName) {
        this.gateway = gateway;
        this.providerName = providerName;
    }

    public NodeElement getValue(String key) {
        Map identityTokens = null;
        try {
            if ("profile".equalsIgnoreCase(key)) {
                identityTokens = this.gateway.getUserAttributes(this.providerName);
            }
            if ("security".equalsIgnoreCase(key)) {
                identityTokens = this.gateway.getSecurityAttributes(this.providerName, false);
            }
        }
        catch (GatewayException e) {
            throw new MapperRuntimeException("Unable to load gateway params from backend for provider name :" + this.providerName, (Throwable)e);
        }
        return new MapNode(identityTokens);
    }

    public void setValue(String key, NodeElement value) {
        throw new MapperRuntimeException("Cannot set value to an identity provider node");
    }

    public void remove(String key) {
    }

    public Set<String> getKeys() {
        return null;
    }
}

