/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodePrimitive;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.mapper.DatasetNode;
import com.konylabs.middleware.mapper.RecordNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapNode
extends AbstractNode {
    private final Map<String, Object> inputMap;

    public MapNode() {
        this(new HashMap<String, Object>());
    }

    public MapNode(Map<String, Object> nodeMap) {
        this.inputMap = nodeMap;
    }

    public NodeElement getValue(String nodeName) {
        Object nodeValue = this.getInputMap().get(nodeName);
        if (nodeValue == null) {
            return null;
        }
        if (nodeValue instanceof Dataset) {
            return new DatasetNode((Dataset)nodeValue);
        }
        if (nodeValue instanceof Record) {
            return new RecordNode((Record)nodeValue);
        }
        if (nodeValue instanceof Param) {
            return new ObjectNodePrimitive(((Param)nodeValue).getObjectValue());
        }
        return new ObjectNodePrimitive(nodeValue);
    }

    public void setValue(String key, NodeElement nodeElement) {
        if (nodeElement instanceof NodePrimitive) {
            Object object = ((NodePrimitive)nodeElement).getValue();
            this.inputMap.put(key, object);
        } else if (nodeElement instanceof RecordNode) {
            RecordNode recNode = (RecordNode)nodeElement;
            this.inputMap.put(key, recNode.getRecord());
        } else if (nodeElement instanceof DatasetNode) {
            DatasetNode datasetNode = (DatasetNode)nodeElement;
            this.inputMap.put(key, datasetNode.getDataset());
        }
    }

    public Map<String, Object> getInputMap() {
        return this.inputMap;
    }

    public void remove(String key) {
        this.inputMap.remove(key);
    }

    public Set<String> getKeys() {
        return this.inputMap.keySet();
    }
}

