/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodePrimitive;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.mapper.DatasetNode;
import com.konylabs.middleware.utilities.MapperUtility;
import java.util.HashSet;
import java.util.Set;

public class RecordNode
extends AbstractNode {
    private final Record record;

    public RecordNode(String recordId) {
        this(new Record());
        this.record.setId(recordId);
    }

    public RecordNode(Record record) {
        this.record = record;
    }

    public Record getRecord() {
        return this.record;
    }

    public NodeElement getValue(String nodeName) {
        Param nodeValue = this.record.getParam(nodeName);
        if (nodeValue != null) {
            return new ObjectNodePrimitive(nodeValue.getObjectValue());
        }
        nodeValue = this.record.getRecordById(nodeName);
        if (nodeValue != null) {
            return new RecordNode((Record)nodeValue);
        }
        nodeValue = this.record.getDatasetById(nodeName);
        if (nodeValue != null) {
            return new DatasetNode((Dataset)nodeValue);
        }
        return null;
    }

    public void setValue(String key, NodeElement nodeElement) {
        if (nodeElement instanceof NodePrimitive) {
            Object object = ((NodePrimitive)nodeElement).getValue();
            Param param = null;
            if (this.record.getParam(key) != null) {
                param = this.record.getParam(key);
            } else {
                param = new Param();
                param.setName(key);
                this.record.addParam(param);
            }
            param.setObjectValue(object);
            if (object != null) {
                param.setValue(String.valueOf(object));
                param.setType(MapperUtility.getType(object));
            }
        } else if (nodeElement instanceof RecordNode) {
            RecordNode recordNode = (RecordNode)nodeElement;
            this.record.addRecord(recordNode.getRecord());
        } else if (nodeElement instanceof DatasetNode) {
            DatasetNode datasetNode = (DatasetNode)nodeElement;
            this.record.addDataset(datasetNode.getDataset());
        }
    }

    public void remove(String key) {
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Dataset dataset : this.record.getAllDatasets()) {
            keys.add(dataset.getId());
            for (Record record : dataset.getAllRecords()) {
                keys.addAll(record.getNameOfAllParams());
            }
        }
        keys.addAll(this.record.getIdOfAllRecords());
        keys.addAll(this.record.getNameOfAllParams());
        return keys;
    }
}

