/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodePrimitive;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.mapper.DatasetNode;
import com.konylabs.middleware.mapper.RecordNode;
import com.konylabs.middleware.utilities.MapperUtility;
import java.util.HashSet;
import java.util.Set;

public class ResultNode
extends AbstractNode {
    private final Result result;

    public ResultNode() {
        this(new Result());
    }

    public ResultNode(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public NodeElement getValue(String nodeName) {
        Param nodeValue = this.result.getParamByName(nodeName);
        if (nodeValue != null) {
            return new ObjectNodePrimitive(nodeValue.getObjectValue());
        }
        nodeValue = this.result.getRecordById(nodeName);
        if (nodeValue != null) {
            return new RecordNode((Record)nodeValue);
        }
        nodeValue = this.result.getDatasetById(nodeName);
        if (nodeValue != null) {
            return new DatasetNode((Dataset)nodeValue);
        }
        return null;
    }

    public void setValue(String key, NodeElement nodeElement) {
        if (nodeElement instanceof NodePrimitive) {
            Object object = ((NodePrimitive)nodeElement).getValue();
            Param param = null;
            if (this.result.getParamByName(key) != null) {
                param = this.result.getParamByName(key);
            } else {
                param = new Param();
                param.setName(key);
                this.result.addParam(param);
            }
            param.setObjectValue(object);
            if (object != null) {
                param.setValue(String.valueOf(object));
                param.setType(MapperUtility.getType(object));
            }
        } else if (nodeElement instanceof RecordNode) {
            RecordNode recNode = (RecordNode)nodeElement;
            this.result.addRecord(recNode.getRecord());
        } else if (nodeElement instanceof DatasetNode) {
            DatasetNode datasetNode = (DatasetNode)nodeElement;
            this.result.addDataset(datasetNode.getDataset());
        }
    }

    public void remove(String key) {
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Dataset dataset : this.result.getAllDatasets()) {
            keys.add(dataset.getId());
            for (Record record : dataset.getAllRecords()) {
                keys.addAll(record.getNameOfAllParams());
            }
        }
        keys.addAll(this.result.getNameOfAllParams());
        keys.addAll(this.result.getIdOfAllRecords());
        return keys;
    }

    public String toString() {
        return "ResultNode [result=" + this.result + "]";
    }
}

