/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.kony.mapper.model.AbstractNodeCreator;
import com.kony.mapper.model.Node;
import com.kony.mapper.model.NodeList;
import com.kony.mapper.model.NodePrimitive;
import com.konylabs.middleware.appservices.common.util.OfflineUtil;
import com.konylabs.middleware.mapper.ServiceOutputNode;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowList;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowPrimitive;
import com.konylabs.middleware.request.builder.RowProcessingStrategy;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class RowNodeCreator
extends AbstractNodeCreator {
    RowMetadata rowMetaData = null;
    RowProcessingStrategy rowSummaryStrategy;

    public RowNodeCreator(RowMetadata rowMetaData, RowProcessingStrategy rowSummaryStrategy) {
        this.rowMetaData = rowMetaData;
        this.rowSummaryStrategy = rowSummaryStrategy;
    }

    public NodeList createNodeList(String nodeName) {
        RowList rowList = new RowList(new JsonArray());
        ObjectMetadata rowListObjectMetadata = null;
        if (this.rowMetaData.getObjectMetadata() != null) {
            rowListObjectMetadata = this.rowMetaData.getObjectMetadata().getAppMetadata().getObjectMetadata(nodeName);
        }
        rowList.setMetadata(new RowMetadata(rowListObjectMetadata, nodeName));
        rowList.getMetadata().setRowSummaryStrategy(this.rowSummaryStrategy);
        return rowList;
    }

    public NodePrimitive createNodePrimitive(Object value) {
        if (value instanceof Number) {
            return new RowPrimitive(new JsonPrimitive((Number)value));
        }
        if (value instanceof Boolean) {
            return new RowPrimitive(new JsonPrimitive((Boolean)value));
        }
        if (value instanceof Date) {
            return new RowPrimitive(new JsonPrimitive(OfflineUtil.getUTCDateFromDate(value)));
        }
        return value != null ? new RowPrimitive(new JsonPrimitive(value.toString())) : new RowPrimitive(new JsonPrimitive(""));
    }

    public Node createNode(String nodeName) {
        if (StringUtils.isEmpty((String)nodeName)) {
            return new ServiceOutputNode();
        }
        Row row = new Row(new JsonObject());
        if (nodeName.equals("response_out")) {
            this.rowMetaData.setRootNode(true);
            row.setMetadata(this.rowMetaData);
        } else {
            ObjectMetadata currentRowObjectMetaData = null;
            if (this.rowMetaData.getObjectMetadata() != null) {
                currentRowObjectMetaData = this.rowMetaData.getObjectMetadata().getAppMetadata().getObjectMetadata(nodeName);
            }
            row.setMetadata(new RowMetadata(currentRowObjectMetaData, nodeName));
        }
        row.getMetadata().setRowSummaryStrategy(this.rowSummaryStrategy);
        return row;
    }
}

