/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.mapper;

import com.kony.adapter.service.constants.CollectionType;
import com.kony.adapter.service.runtime.AbstractServiceList;
import com.kony.adapter.service.runtime.AbstractServiceObject;
import com.kony.adapter.service.runtime.AbstractServiceParam;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.mapper.model.AbstractNodeList;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodePrimitive;
import com.kony.mapper.model.impl.object.ObjectNodePrimitive;
import com.konylabs.middleware.mapper.IterableWrapper;
import com.konylabs.middleware.mapper.IteratorWrapper;
import com.konylabs.middleware.mapper.ServiceDataNode;
import com.konylabs.middleware.mapper.ServiceDataNodeCreatorFactory;

public class ServiceDataList
extends AbstractNodeList {
    private final AbstractServiceList serviceList;

    public ServiceDataList(AbstractServiceList serviceList) {
        this.serviceList = serviceList;
    }

    public AbstractServiceList getServiceList() {
        return this.serviceList;
    }

    public Iterable<NodeElement> getNodeElements() {
        if (this.serviceList == null) {
            return null;
        }
        return new IterableWrapper<ServiceData, NodeElement>(this.serviceList.getParamRecordDataset(), new IteratorWrapper.Converter<ServiceData, NodeElement>(){

            @Override
            public NodeElement convert(ServiceData servData) {
                if (servData.getType() == CollectionType.PARAM) {
                    return new ObjectNodePrimitive(((AbstractServiceParam)servData).getValue());
                }
                if (servData.getType() == CollectionType.RECORD) {
                    return new ServiceDataNode((AbstractServiceObject)servData);
                }
                if (servData.getType() == CollectionType.DATASET) {
                    return new ServiceDataList((AbstractServiceList)servData);
                }
                return null;
            }
        });
    }

    public void addNodeElement(NodeElement nodeElement) {
        if (nodeElement instanceof NodePrimitive) {
            Object serviceDataPrimitive = ((NodePrimitive)nodeElement).getValue();
            AbstractServiceParam serviceParam = ServiceDataNodeCreatorFactory.getNodeCreator((ServiceData)this.serviceList).createServiceParam("", serviceDataPrimitive);
            this.serviceList.addParamRecordDataset((ServiceData)serviceParam);
        } else if (nodeElement instanceof ServiceDataNode) {
            this.serviceList.addParamRecordDataset((ServiceData)((ServiceDataNode)nodeElement).getServiceObject());
        } else if (nodeElement instanceof ServiceDataList) {
            this.serviceList.addParamRecordDataset((ServiceData)((ServiceDataList)nodeElement).getServiceList());
        }
    }
}

